Require oo.tcl
Require label.tcl
Require option.tcl

_option(Add) message.font "*-helvetica-medium-r-normal--*-120-*" 
_option(Add) message.color(Message) black 
_option(Add) message.color(Error) red3 
_option(Add) message.width 30 
_option(Add) message.relief ridge 


ooRoot Instance Message {
  Var message mcolor ecolor permanent
  Var {code CSERROR} {code-OK CSERROR_OK} {print true}

  Method Install {} {
    global _label
    _label(Label) . message "" [var message]
    pack configure .message -fill x -before .mbar -side bottom -padx 2 -pady 0
    frame .message(pad) -height 2
    pack .message(pad) -before .message -side bottom
    set [var mcolor] [option get .message color(Message) *]
    set [var ecolor] [option get .message color(Error) *]
    catch {
      auto_load tkerror
      rename tkerror [-oo(MethodName) [Self] tkerror]
    }
    proc tkerror {message} {uplevel [list Message Error $message]}
    bind _message(map) <Any-KeyPress> {Message Clear}
    bindtags .definition [concat _message(map) [bindtags .definition]]
  }

  Method Set {text {update 1} {color {}} {permanent 0}} {
    if {$color == ""} {set color [val mcolor]}
    if {[llength [split $text \n]] > 3} {
      set [var message] ""
      ConfirmOK $text
    } else {
      set [var message] $text
      set [var permanent] $permanent
      .message configure -foreground $color
      if {$update} {update idletasks}
    }
  }

  Method Clear {} {
    if ![val permanent] {set [var message] {}}
  }

  Method Error {message} {
    global errorInfo errorCode
    Vars code code-OK print ecolor
    if {$errorCode == $code} {
      if {$print} {puts stderr $message}
      Self Set $message 1 $ecolor
      bell
    } elseif {$errorCode == ${code-OK}} {
      ConfirmOK $message
    } else {
      Self Clear
      uplevel [list Self tkerror $message]
    }
  }

}

proc Error {message} {
  return -code error -errorcode [Message get code] $message
}

proc ErrorOK {message} {
  return -code error -errorcode [Message get code-OK] $message
}

Require fname.tcl
proc _fname(Error) [info args ErrorOK] [info body ErrorOK]
