Require oo.tcl
Require bind.tcl

Require packdata.tcl
Require color.tcl
Require appearance.tcl
Require reference.tcl
Require olist.tcl

PackData Subclass ObjectData {
  Var status autoUpdate normalize {needsUpdate 1}
  ClassVar {default {selected 1 each}}
  ClassVar {data {status autoUpdate normalize}}
  ClassVar {array _object}

  Method Restore {} {
    global _object
    Parent Restore
    if ![[Owner Group] isTop] {
      set _object(normalize) [[Owner TopGroup] Object get normalize]
    }
  }
}



ooRoot Subclass csObject {
  Var type script {written 0} {computed 0} {spos {0.0 0 0}}
  Var mcolor Mcolor mRGB MRGB
  ClassVar {linkable-types {}}
  ClassVar create() templates()
  ClassVar {script-templates {}}
  ClassVar template-list
  ClassVar {pack-list {Object Color Appearance Reference}}
  ClassVar {save-list {Object Color Appearance Reference
                       Slider TypeIn CheckBox}}
  ClassVar {widget-list {Slider TypeIn CheckBox}}
  ClassVar {type {}}

  ObjectData Instance Object
  ColorData Instance Color
  AppearanceData Instance Appearance
  ReferenceData Instance Reference
  Sliders Instance Slider
  TypeIns Instance TypeIn
  CheckBoxes Instance CheckBox

  Method Update {{define 1}} {
    global errorCode errorInfo
    _expr(Clear)
    puts "(progn"
    set code [catch {
      Self Reference UpdateBegin
      if {$define} {Self Define}
      set object [Self]
      set group [Self Group]
      while {![$group isTop] && ![$group get computed]} \
      {
        set object $group
        set group [$object Group]
      }
      $object Recompute
      Self Reference UpdateEnd
    } result]
    puts ")"; flush stdout
    return -code $code -errorinfo $errorInfo -errorcode $errorCode $result
  }

  Method Define {} {
    Self Save
    Self HandleScript
    Self Restore 0
    set [var computed] 0
  }

  Method Recompute {{group 1}} {
    if {[Self Reference NeedsCompute]} {
      if [Self HandleCompute] {Self HandleOOGL} else {Self DeleteGeometry}
      if {$group} {[Self Group] HandleOOGL}
      Self Reference ComputeReferrers
    }
  }

  Method _Select {} {
    if {[string compare [Self] [Self TopGroup]] == 0} {set state disabled} \
      else {set state normal}
    .mbar.object.menu entryconfigure Remove* -state $state
    .mbar.object.menu entryconfigure Add* -state $state
  }

  Method Select {} {}
  Method Unselect {} {}
  Method Compute {} {}
  Method Recolor {} {}
  Method SetValues {} {}

  Method StatusCheck {type} {
    set group [Self Group]
    if [$group isTop] {
      if ![val computed] return
      if {$type == 1} {Self setDimension}
      if {[Self Object get status] != "selected"} return
      if {$type == 0} {Self DeleteGeometry} else {Self CreateGeometry}
    } else {$group HandleOOGL}
  }

  Method isShowable {{ignoreshow 0}} {
    if {$ignoreshow} {set showme 1} else {set showme [val showme]}
    set status [Self Object get status]
    set status [expr {![Self isTop] && $showme && $status != "hide" && \
      ($status != "selected" || [[_Current] TopGroup] == [Self TopGroup])}]
    return $status
  }

  Method HandleScript {} {
    global errorCode errorInfo
    Vars script type computed

    Self ScriptBegin
    regsub -all "\\\\\n *" $script { } lines
    set cmd {}
    foreach line [split $lines \n] {
      if {[string compare [string index [string trim $line] 0] "\#"] == 0} \
	  continue
      if {$cmd == ""} {set cmd $line} else \
	  {set cmd [join [list $cmd $line] \n]}
      if {[info complete $cmd] && [string trim $cmd] != ""} {
	set proc [lindex $cmd 0]
	if [catch {Self method <${proc}>}] \
	    {Error "Unknown action '$proc' for object '$type'"}
	set cmd [lreplace $cmd 0 0 Self <${proc}>]
	if [set code [catch [list uplevel \#0 $cmd] err]] \
	  {return -code $code -errorcode $errorCode -errorinfo $errorInfo $err}
	set cmd {}
      }
    }
    if {$cmd != ""} {Error "Incomplete command:\n\"$cmd\""}
    Self ScriptEnd
    Self SetValues
  }

  Method HandleCompute {} {
    Self ComputeInit
    if {![val showme]} {return 0}
    Message Set "Computing [Self]..."
    Self SetValues
    Self Compute
    Message Clear
    _Object NeedsUpdate [Self] 0
    return [set [var computed] 1]
  }

  Method HandleOOGL {} {
    if ![Self isShowable] return
    puts "(read geometry {"
    puts "  define O:[Self]"
    Self WriteObject stdout
    puts "})"
    Self CreateAppearance
    Self CreateGeometry
    flush stdout
    Self Color Uncolored
  }

  Method HandleColor {} {
    Vars written computed showme
    if {!$written} return
    Self Save
    if {!$computed} {Self Recompute} else {
      if {[string index [Self Color get by] 0] != " " ||
	  ![Self Color get uncolored]} {
        Message Set "Recoloring [Self]..."
	Self ComputeInit
        if {$showme} {
	  Self Recolor
	  Self HandleOOGL
        }
        Message Clear
      } else {Self HandleAppearance}
    }
  }

  Method HandleAppearance {} {
    Vars written computed
    if {!$written} return
    Self Save
    if {!$computed} {Self Recompute} else {
      Self CreateAppearance
      puts "(redraw c0)"
      flush stdout
    }
  }

  Method ComputeInit {{first 1}} {
    Vars widget-list showme showme-expr
    if {$first} {Self Reference BeginInit} \
      elseif {![Self Reference NeedsInit]} return
    if {[set object [Self Reference Object]] != "_NOOP"} \
      {uplevel $object ComputeInit 0}
    uplevel {
      upvar \#0 pi pi
      upvar \#0 e e
      upvar \#0 i i
    }
    set i 0
    foreach x [Self Inherit axes] {
      catch {uplevel [list set _X($i) 0]}
      catch {uplevel [list upvar 0 _X($i) $x]}
      incr i
    }
    foreach class ${widget-list} {uplevel Self $class ComputeInit}
    set object [Self]; set olist {}
    while {![$object isTop]} {
      set olist [concat $object $olist]
      set object [$object Group]
    }
    foreach object $olist {uplevel [$object get compute-init]}
    set showme [uplevel [list _expr(Math) ${showme-expr}]]
  }

  Method CreateAppearance {} {
    Vars written
    set self [Self]
    puts "(read geometry {"
    puts "  define G:$self"
    puts "  appearance {"
    Self WriteAppearance stdout
    puts "  }"
    puts "  : O:$self"
    puts "})"
    flush stdout
    set written 1
  }
  Method CreateGeometry {} {
    if [[Self Group] isTop] {
      set self [Self]
      Self setDimension
      puts "(geometry $self { : G:$self })"
      puts "(normalization $self [Self Object get normalize])"
      flush stdout
    }
  }
  Method DeleteGeometry {} {
    set self [Self]
    puts "(if (real-id $self) (delete $self))"
    flush stdout
  }
  Method DeleteAllGeometry {} {
    Vars written
    Self DeleteGeometry
    if $written {
      set self [Self]
      puts "(hdefine geometry O:$self { LIST })"
      puts "(hdefine geometry G:$self { LIST })"
      set written 0
    }
  }

  Method AutoUpdate {} {
    global _object
    _File Changed 1
    if $_object(autoUpdate) {_button(Invoke) .bbox.update}
  }

  Method AutoColor {} {
    global _object
    _File Changed 1
    Self Color Update
    if $_object(autoUpdate) {Self HandleColor} \
	else {_Object NeedsUpdate [Self]}
  }
  Method AutoApp {} {
    global _object _app
    if {$_app(lineW) != "other"} {set _app(lineWidth)    $_app(lineW)}
    if {$_app(trans) != "other"} {set _app(transparency) $_app(trans)}
    _File Changed 1
    Self Appearance MenuCheck
    if {$_object(autoUpdate)} {Self HandleAppearance} \
	else {_Object NeedsUpdate [Self]}
  }


  ClassVar dimension
  Method setDimension {} {
    Vars dimension
    set d [llength [Self Inherit zero]]
    if {$d != $dimension} {
      set dimension $d
      if {$d == 3} {set d 0}
      puts "(dimension $d)"; flush stdout
    }
  }
  Method getDimension  {} {return [llength [Self Inherit zero]]}
  Method realDimension {} {return [llength [Self Inherit axes]]}

  Method Status {} {
    Self Save
    set group [Self Group]
    if [$group isTop] {
      if ![val computed] return
      if {[Self Object get status] == "hide" || ![val showme]} \
	  {Self DeleteGeometry} else {Self CreateGeometry}
      flush stdout
    } else {$group HandleOOGL}
  }

  Method Normalize {{again {}}} {
    global _object
    if {$again == "again"} {set _object(normalize) keep}
    Self Save
    set object [Self TopGroup]
    $object Object set normalize $_object(normalize)
    $object Object Pack
    if {$again == "again"} \
	{puts "(if (real-id $object) (normalization $object each))"}
    puts "(if (real-id $object) (normalization $object $_object(normalize)))"
    flush stdout
  }


  Method Save {} {
    Vars script save-list spos
    if {[string compare [Self] [_Current]] == 0} {
      set spos [Self GetScriptPos]
      set oldscript $script
      set script [.definition get 0.0 end-1c]
      if {[string compare $oldscript $script] != 0} {_File Changed 1}
      foreach object ${save-list} {Self $object Save}
    }
  }

  Method Restore {{update 1}} {
    Vars script save-list spos
    foreach object ${save-list} {Self $object Restore}
    if {$update} {
      .definition delete 0.0 end
      .definition insert insert $script
      Self SetScriptPos $spos
      focus .definition
    }
  }

  Method GetScriptPos {} {
    return [list \
      [.definition index insert] \
      [lindex [.definition xview] 0] \
      [lindex [.definition yview] 0] \
    ]
  }

  Method SetScriptPos {pos} {
    .definition mark set insert [lindex $pos 0]
    .definition xview moveto [lindex $pos 1]
    .definition yview moveto [lindex $pos 2]
    .definition see insert
  }

  Method Pack {} {
    Vars script pack-list
    set list [list [_pack(Quote) $script]]
    foreach object ${pack-list} {lappend list [Self $object Pack]}
    return $list
  }

  Method Unpack {list} {
    Vars script pack-list
    if [_File EarlierV 1.1] {set list [linsert $list 4 {}]}
    set script [_unpack(Quote) [lindex $list 0]]
    if {$script == ""} {set script [Self Template script]}
    set i 1
    foreach object ${pack-list} {Self $object Unpack [lindex $list $i]; incr i}
  }

  Method Template {type} {
    if {$type == "script"} {
      set template {}
      foreach type [val script-templates] \
	  {lappend template [Self Template $type]}
      set template [join $template \n\n]
    } else {
      if [catch {set template [concat $type [val $type-template]]}] \
	  {Error "No template available for '$type'"}
    }
    return $template
  }

  Method TemplateList {} {
    Vars templates
    Self setContext [Self baseContext]
    set self [Self]
    if [info exists templates($self)] {return $templates($self)}
    if {[string compare $self "csObject"] == 0} {set list ""} \
	else {set list [Self Parent TemplateList]}
    foreach var [info globals [-oo(VarName) $self *-template]] {
      regsub -- {.*\.([^\.]*)-template$} $var {\1} var
      lappend list $var
    }
    set all {}; set last ""
    foreach var [lsort $list] {
      if {[string compare $last $var] != 0} {lappend all $var}
      set last $var
    }
    return $all
  }

  Method Register {{name {}}} {
    set self [Self]
    if {$name == ""} {set name $self}
    set [var create($name)] $self
    set [var templates($name)] [Self TemplateList]
  }
  Method AutoLoad {name {register 1}} {
    proc $name {args} [join [list \
      "set message \[Message get message\]" \
      "Message Set {Autoloading Class/$name...}" \
      "rename $name {}" \
      "uplevel \#0 Require {Class/$name}" \
      "Message Set \$message" \
      "uplevel $name \$args"
    ] \n]
    if {$register} {set [var create($name)] $name}
  }

  Method Create {name {data ""}} {
    set type [Self]
    set base [_File get base]
    while {[$type isInstance]} {set type [$type Parent]}
    set name [_Object uniqueName "$base$name"]
    if [_File get ignore] {set data ""}
    $type Instance $name
    $name set type $type
    $name Unpack $data
    catch [list uplevel \#0 $name HandleScript]
    _File First $name
    _File Changed 1
    [$name Group] Add $name
    if {$base == "[$name Group]/"} {[$name Group] NewAddition $name}
    return $name
  }

  Method Group {} {
    set group [file dirname [Self]]
    if {[string compare $group "."] == 0} {set group _Object}
    return $group
  }
  Method BaseGroup {} {
    set base [file dirname [Self]]
    if {[string compare $base "."] == 0} {set base ""} else {set base "$base/"}
    return $base
  }
  Method isTop {} {return 0}
  Method TopGroup {} {
    set group [Self Group]
    if [$group isTop] {return [Self]}
    regsub {/.*} $group {} group
    return $group
  }
  Method CheckName {name} {
    if [regexp {/} $name] {
      set group [file dirname $name]
      if {[info procs $group] == ""} {ErrorOK "Group '$group' doesn't exist"}
      if {[$group get type] != "Group"} \
        {ErrorOK "Object '$group' is not a group"}
    }
  }

  Method TypeMatch {type} {
    if {$type == "*" || $type == ""} {return 1}
    set object [Self]
    while {$object != "csObject"} {
      if {$object == $type} {return 1}
      set object [$object Parent]
    }
    return 0
  }

  Method Referrers {{name ""}} {return [Self Reference Referrers $name]}

  Method WriteCS {file {base ""}} {
    Vars type
    set self [Self]
    if {$base != ""} {
      set prefix [string range $self 0 [expr [string length $base] - 1]]
      if {[string compare $base $prefix] == 0} \
	  {set self [string range $self [string length $base] end]}
    }
    puts $file "\n\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\n"
    puts $file "$type Create $self {"
    foreach item [Self Pack] {puts $file "  {$item}"}
    puts $file "}"
  }

  Method WriteObject {file} {
    Vars computed
    if $computed {Self WriteOOGL $file} else {puts $file "LIST"}
  }

  Method WriteAppearance {file} {
    Vars appearance
    Self Appearance Write $file
    if {$appearance != ""} {puts $file $appearance}
  }

  Method WriteOOGL {file} {}

  Method GetPoly {} {}
  Method ListParts {} {return ""}


  Method New {} \
      {_NewObject Request "New object name:" "Untitled" "[Self] _New"}
  Method _New {name type} {
    _File Changed 1
    if [regexp {/} $name] {Self CheckName $name} else {
      set group [Self Group]
      if ![$group isTop] {set name "$group/$name"}
    }
    set name [[csObject get create($type)] Create $name]
    [$name Group] NewAddition $name
    _Object Display $name
    if {[$name get linkable-types] != ""} \
      {_SelectObject Request LinkableObjects "$name _LinkTo"}
  }

  Method AddNew {} \
    {_NewObject Request "New object name:" "Untitled" "[Self] _AddNew"}

  Method _AddNew {name type} {
    _File Changed 1
    if ![regexp {/} $name] {set name "[Self Group]/$name"}
    Self _New $name $type
  }

  Method Duplicate {} {
    set self [Self]
    set name [file tail [_Object uniqueName $self]]
    _name(Request) "Name for duplicate object:" $name \
      "_Object Display \[$self _Duplicate \"[Self BaseGroup]\$_name(name)\"\]"
  }
  Method _Duplicate {new} {
    Self CheckName $new
    Self Save
    _File Changed 1
    set new [[val type] Create $new [Self Pack]]
    $new Reference Duplicate [Self]
    if {[[$new Group] isTop] != [[Self Group] isTop]} \
      {[$new Group] NewAddition $new}
    return $new
  }

  Method Rename {} {
    set self [Self]
    set name [file tail $self]
    _name(Request) "Rename object '$name' as:" $name \
	"_Object Display \[$self _Rename \"[Self BaseGroup]\$_name(name)\"\]"
  }
  Method _Rename {new} {
    Self CheckName $new
    Self Save
    set old [Self]
    if {[string compare $old $new] != 0} {
      _Object SetCurrent [_Default]
      set prefix [string range $new 0 [string length $old]]
      if {[string compare $prefix "$old/"] == 0} \
	  {Error "Can't form recursive group structures"}
      set new [$old Parent Create $new [$old Pack]]
      $new Reference Rename $old
      if {[[$new Group] isTop] != [[$old Group] isTop]} \
        {[$new Group] NewAddition $new}
      $old _Delete
    }
    return $new
  }

  Method MoveToGroup {} {_SelectObject Request Groups "[Self] _MoveToGroup"}
  Method _MoveToGroup {object} {
    if {$object != ""} \
      {_Object Display [Self _Rename "$object/[file tail [Self]]"]}
  }
  Method RemoveFromGroup {} \
    {_Object Display [Self _Rename [file tail [Self]]]}

  Method LinkTo {} {_SelectObject Request LinkableObjects "[Self] _LinkTo"}
  Method _LinkTo {object} {
    Self Reference Set $object
    catch {Self SetValues}
    Self Restore 0
  }

  Method Delete {} {
    set refs [Self Referrers [Self]]
    if {$refs != ""} {
      if [Confirm [join [list \
           "'[Self]' or its parts is referred to by the following objects:" \
           [join $refs \n] \
           "Delete anyway?" \
         ] \n]] return
    } elseif {[Confirm "Really delete object '[Self]'?"]} return
    _Object SetCurrent [_Default]
    Self _Delete
    _File Changed 1
    _Object Display [_Current]
  }
  Method _Delete {} {
    [Self Group] Remove [Self]
    Self DeleteAllGeometry
    Self Reference Clear
    Self Destroy
  }

  Method Import {} {
    _fname(OldFile) "Import objects from file:" "" \
	"_File _Load {%N} {} [Self Group]" .cs [_File get pwd]
  }

  Method Export {} {
    set self [Self]
    _fname(NewFile) "Export object '$self' to file:" "[file tail $self].cs" \
	{_File _Save {%N} new selected} .cs [_File get pwd]
  }

  Method SaveOOGL {} {
    set self [Self]
    _fname(NewFile) "Save OOGL for '$self' to file:" "[file tail $self].oogl" \
	"$self _SaveOOGL {%N}" .oogl [_File get pwd]
  }
  Method _SaveOOGL {name} {
    global _program
    Self Save
    if ![val computed] {Self HandleCompute}
    set file [open $name w]
    puts $file "\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\n\#"
    puts $file "\#  File:     $name"
    puts $file "\#  Created:  [exec date]"
    puts $file "\#  By:       $_program(id)"
    puts $file "\#  Object:   [Self]"
    puts $file "\#\n"
    puts $file "appearance {"
    Self WriteAppearance $file
    puts $file "}\n"
    Self WriteObject $file
    close $file
  }


  Method Inherit {var} {
    set object [Self]
    while {[set val [$object get $var]] == "" &&
           ![$object isTop]} {set object [$object Group]}
    return $val
  }
  Method InheritVars {args} {
    foreach var $args {uplevel [list set $var [Self Inherit $var]]}
  }
  Method InheritReference {var} {
    if {$var == "axes" || $var == "point" || $var == "zero"} {
      return [[Self Reference Object] Inherit $var]
    } else {
      return [Parent Inherit $var]
    }
  }


  Var {axes {x y z}} {point {list $x $y $z}} {zero {0 0 0}}
  Method <Axes> {axes} {
    Vars point zero
    set axes [join $axes " "]
    regsub -all { } $axes { $} point
    set point "list \$$point"
    regsub -all {[^ ]+} $axes {0} zero
    while {[llength $zero] < 3} {lappend zero 0; lappend point 0}
    set [var axes] $axes
  }
  ClassVar {Axes-template {{x y z}}}

  Var appearance
  Method <Appearance> {app} {set [var appearance] $app}
  ClassVar "Appearance-template {{\n  (appearance)\n}}"

  Var colorfn()
  Method <ColorFunction> {name script} {set [var colorfn($name)] $script}
  ClassVar {ColorFunction-template {(name) {(formula)}}}

  Var compute-init
  Method <Setup> {body} {set [var compute-init] $body}
  ClassVar "Setup-template {{\n  (commands)\n}}"

  Var {showme 1} {showme-expr 1}
  Method <ShowMe> {expr} {set [var showme-expr] $expr}
  ClassVar {ShowMe-template {{(expression)}}}

  Method <Slider> {name min max args} {
    global errorCode errorInfo
    set resolution .01; set ticks 0
    if [set code [catch [list _bind(Rest) {{init ""}} \
        {{resolution= .01} {ticks= 0} {digits= {}} {title= {}}} $args \
        [Self method <Slider>]] err]] \
	{return -code $code -errorcode $errorCode -errorinfo $errorInfo $err}
    set min [uplevel [list _expr(Math) $min]]
    set max [uplevel [list _expr(Math) $max]]
    if {$init != ""} {set init [uplevel [list _expr(Math) $init]]}
    Self Slider Add \
      [list $name $min $max $init $resolution $ticks $digits $title]
  }
  ClassVar {Slider-template {(name) (min) (max) (init)}}

  Method <TypeIn> {name init args} {
    global errorCode errorInfo
    if [set code [catch [list _bind(Rest) {} \
        {{title= ""} {lines= {}} {width= {}}} $args \
	[Self method <TypeIn>]] err]] \
        {return -code $code -errorcode $errorCode -errorinfo $errorInfo $err}
    Self TypeIn Add [list $name $init $lines $width $title]
  }
  ClassVar {TypeIn-template {(name) (init)}}

  Method <CheckBox> {name {init 0} {title ""}} {
    if {$title == ""} {set title $name}
    Self CheckBox Add [list $name $init $title]
  }
  ClassVar {CheckBox-template {(name) (init) (title)}}

  Method <proc> {name args body} {proc $name $args $body}

  Method ScriptBegin {} {
    Vars axes point zero 
    Vars appearance colorfn
    Vars widget-list compute-init showme showme-expr
    set axes {}
    set point {}
    set zero {}
    set appearance {}
    set compute-init {}
    set showme 1
    set showme-expr 1
    foreach fn [array names colorfn] {unset colorfn($fn)}
    set colorfn(RGB=XYZ) {$_X(0) $_X(1) $_X(2)}
    foreach class ${widget-list} {Self $class Init}
  }

  Method ScriptEnd {} {}
  Method ColorMenus {} {}
}

proc _pack(Quote) {string} {
  regsub -all {[\{\}]} $string {\\&} string
  return $string
}

proc _unpack(Quote) {string} {
  regsub -all {\\([\{\}])} $string {\1} string
  return $string
}

proc _script(Run) {script {level 2}} {
  global errorInfo errorCode
  return -code [uplevel $level [list catch $script _script(err)]] \
      -errorcode $errorCode -errorinfo $errorInfo \
      [uplevel $level set _script(err)]
}
