Require oo.tcl
Require packdata.tcl

set _color(count) 50
set _color(default) [list \
  "{1 0 0} $_color(count) Red" \
  "{1 1 0} $_color(count) Yellow" \
  "{0 1 0} $_color(count) Green" \
  "{0 1 1} $_color(count) Cyan" \
  "{0 0 1} $_color(count) Blue" \
  "{1 0 1} $_color(count) Purple" \
]

set _color(menu-solid) {}
set _color(menu-function) {}
set _color(menu-coord) {}

proc _color(Fn) {var} {
  global _color
  set var $_color(FN-array)($var)
  set color [uplevel \#0 set $var]
  return [_expr(List) $color]
}

proc _color(Clamp) {x} {return [expr ($x<0.0)?0.0:($x>1.0)?1.0:$x]}
proc _color(ClampRGB) {r g b} \
  {return [list [_color(Clamp) $r] [_color(Clamp) $g] [_color(Clamp) $b]]}

proc _color(Var) {var} {return [uplevel set {$var}]}
proc _color(Solid) {rgb} {return $rgb}

PackData Subclass ColorData {
  Var by wrap normalize color-list inherit
  Var colors RGB max wmax {uncolored 0}
  ClassVar "default {{} 0 1 {$_color(default)} 1}"
  ClassVar {data {by wrap normalize color-list inherit}}
  ClassVar {array _color}

  Method Restore {} {
    Parent Restore
    Self MenuCheck
    Self SetInheritMenu
  }

  Method MenuCheck {} {
    Vars colors color-list by inherit
    global _color
    if {!$inherit && [string compare $colors ${color-list}] != 0} \
	{Self MakeTable}
    set _color(by-old) $_color(by)
    set _color(by) ""
    Self Menus
    if {$_color(by) == ""} {
      set _color(by) "set [lindex [Owner Inherit axes] end]"
      set by $_color(by)
    }
    set _color(by-old) $_color(by)
  }

  Method Menus {} {
    global _color
    set axes [Owner Inherit axes]
    upvar \#0 [Owner var colorfn] colorfn

    if {[string compare $_color(menu-coord) $axes] == 0} {
      foreach item $axes \
	  {if {$_color(by-old) == "set $item"} {set _color(by) "set $item"}}
    } else {
      set _color(menu-coord) $axes
      .mbar.color.menu.coordinate delete 0 end
      .mbar.color.menu entryconfigure "by Coordinate" -state disabled
      foreach item $axes {
	set value "set $item"
	.mbar.color.menu.coordinate add radio -label $item \
	    -variable _color(by) -command {[_Current] AutoColor} -value $value
	if {[string compare $value $_color(by-old)] == 0} \
	    {set _color(by) $value}
      }
    }
    .mbar.color.menu entryconfigure "by Coordinate" -state normal

    set functions [lsort [array names colorfn]]
    if {[string compare $_color(menu-function) $functions] == 0} {
      if {[string range $_color(by-old) 0 5] == "_color"} \
	  {set _color(by) $_color(by-old)}
    } else {
      set _color(menu-function) $functions
      .mbar.color.menu.function delete 0 end
      .mbar.color.menu entryconfigure "by Function" -state disabled
      foreach item $functions {
	set value "_color(Fn) $item"
	.mbar.color.menu.function add radio -label $item \
	    -variable _color(by) -value $value -command {[_Current] AutoColor}
	if {[string compare $value $_color(by-old)] == 0} \
	    {set _color(by) $value}
	.mbar.color.menu entryconfigure "by Function" -state normal
      }
    }

    Self getRGB
    if {[string compare $colors $_color(menu-solid)] == 0} {
      if {[string index $_color(by-old) 0] == " "} {
	set _color(by) $_color(by-old)
	Self SetSolidColor
      }
    } else {
      set _color(menu-solid) $colors
      set n [expr [.mbar.color.menu.solid index end] - 2]
      if {$_color(menu-solid) != ""} {.mbar.color.menu.solid delete 2 $n}
      set i 0; set n 2
      foreach rgb $_color(menu-solid) {
	set value " list [lindex $rgb 0]"
	.mbar.color.menu.solid insert $n radio -label [lindex $rgb 2] \
	    -variable _color(by) -command {[_Current] AutoColor} -value $value
	if {[string compare $value $_color(by-old)] == 0} \
	    {set _color(by) $value}
	incr i [lindex $rgb 1]; incr n
      } 
      if {$_color(by) == "" && [lindex $_color(by-old) 0] == "list"} {
        set $_color(by) $_color(by-old)
        .mbar.color.menu.solid entryconfig Other* -value $_color(by)
      }
    }

    Owner ColorMenus
  }

  Method SetSolidColor {} {
    global _color
    foreach rgb $_color(menu-solid) {
      if {[string compare [lindex $rgb 0] [lrange $_color(by) 1 end]] == 0} {
	.mbar.color.menu.solid entryconfig Other* -value {other}
	return
      }
    }
    .mbar.color.menu.solid entryconfig Other* -value $_color(by)
  }

  Method Other {} {
    global _color
    set c {.5 .5 .5}
    if {[lindex $_color(by-old) 0] == "list"} \
	{set c [lrange $_color(by-old) 1 end]}
    _SelectRGB Request $c "[Self] _Other" {}
  }
  Method _Other {c} {
    global _color
    if {$c == ""} {set _color(by) $_color(by-old)} else {
      set _color(by) " list $c"
      Owner AutoColor
    }
  }

  Method Update {} {
    global _color
    set _color(by-old) $_color(by)
    if {[lindex $_color(by) 0] == "list"} {Self SetSolidColor}
  }

  Method SetInheritMenu {} {
    global _color
    if $_color(inherit) {set state disabled} else {set state normal}
    .mbar.color.menu entryconfigure Edit* -state $state
  }

  Method Inherit {} {
    global _color
    Self SetInheritMenu
    Self Save
    if $_color(inherit) {
      set [var RGB] {}
      set [var colors] {}
    } else {
      Self getRGB
      if {[string compare $colors [val color-list]] == 0} {
	set [var color-list] $colors
	set [var colors] $colors
	set [var RGB]  $RGB
	set [var max]  $max
	set [var wmax] $wmax
      } else {
	Self MakeTable
      }
    }
    Owner HandleColor
  }

  Method MakeTable {} {
    Vars RGB max wmax colors color-list wrap inherit
    if {$inherit} return
    set colors ${color-list}
    set default [_Default]
    if {[string compare ${color-list} [$default Color get colors]] == 0 &&
	[$default Color get max] != ""} {
      set RGB  [$default Color get RGB]
      set max  [$default Color get max]
      set wmax [$default Color get wmax]
    } else {
      set table ${color-list}
      lappend table [lindex ${color-list} 0]
      set count [expr [llength $table] - 1]
      set RGB {}
      for {set j 0; set wmax 0; set max 0} {$j < $count} \
	  {incr j; set max $wmax; incr wmax $n} {
	set RGB1 [lindex [lindex $table $j] 0]
	set RGB2 [lindex [lindex $table [expr $j+1]] 0]
	set n    [lindex [lindex $table $j] 1]
	for {set i 0} {$i < $n} {incr i} {
	  set r [expr double($i)/double($n)]
	  for {set rgb {}; set k 0} {$k < 3} {incr k} {
	    set m [lindex $RGB1 $k]; set M [lindex $RGB2 $k]
	    lappend rgb [expr $m + $r * ($M - $m)]
	  }
	  lappend RGB $rgb
	}
      }
      lappend RGB $RGB2
    }
  }

  Method getRGB {} {
    set owner [Owner]
    while {[$owner Color get inherit]} {set owner [$owner Group]}
    uplevel [list upvar \#0 [$owner Color var RGB] RGB]
    uplevel [list upvar \#0 [$owner Color var max] max]
    uplevel [list upvar \#0 [$owner Color var wmax] wmax]
    uplevel [list upvar \#0 [$owner Color var colors] colors]
  }

  Method Get {r} {
    Self getRGB
    if [val wrap] {set n $wmax} else {set n $max}
    if {$r < 0} {set $r 0} elseif {$r > 1} {set r 1}
    return [lindex $RGB [expr int($r*$n)]]
  }

  Method Init {} {
    global _color
    set _color(FN-array) [Owner var colorfn]
    uplevel [list upvar \#0 [Owner var mcolor] mcolor]
    uplevel [list upvar \#0 [Owner var Mcolor] Mcolor]
    uplevel [list upvar \#0 [Owner var mRGB] mRGB]
    uplevel [list upvar \#0 [Owner var MRGB] MRGB]
    uplevel {set mcolor 100000.0; set Mcolor -100000.0}
    uplevel {set mRGB 100000.0; set MRGB -100000.0}
    uplevel [list set by [val by]]
    uplevel [list set ColorFN [Self method Compute]]
    uplevel [list set ComputeMaxMin [Self method ComputeMaxMin]]
  }

  Method Compute {{fn {}}} {
    upvar mcolor mcolor; upvar Mcolor Mcolor; upvar by by
    upvar mRGB mRGB; upvar MRGB MRGB
    if {$fn != ""} {set color [uplevel 2 $fn]} \
      else {set color [uplevel 2 $by]}
    if {[llength $color] == 1} {
      if {$color < $mcolor} {set mcolor $color}
      if {$color > $Mcolor} {set Mcolor $color}
    } else {
      foreach c $color {
        if {$c < $mRGB} {set mRGB $c}
	if {$c > $MRGB} {set MRGB $c}
      }
    }
    return $color
  }

  Method ComputeMaxMin {colors} {
    upvar mcolor mcolor; upvar Mcolor Mcolor; upvar by by
    upvar mRGB mRGB; upvar MRGB MRGB
    set orig $colors
    if {[string compare [lindex $colors 0] \
                        [lindex [lindex $colors 0] 0]] == 0} \
      {set colors [list $colors]}
    foreach color $colors {
      if {[llength $color] == 1} {
        if {$color < $mcolor} {set mcolor $color}
        if {$color > $Mcolor} {set Mcolor $color}
      } else {
        foreach c $color {
          if {$c < $mRGB} {set mRGB $c}
	  if {$c > $MRGB} {set MRGB $c}
        }
      }
    }
    return $orig
  }

  Method Normalize {list} {
    Vars normalize wrap
    upvar mcolor m; upvar Mcolor M; upvar mRGB mRGB; upvar MRGB MRGB
    Self getRGB
    if $wrap {set n $wmax} else {set n $max}

    set adjust 0
    if {$normalize} {
      set adjustC   {($c <= 0)? 0.0: ($c >= 1)? 1.0: double($c)}
      set adjustRGB {($rgb <= 0)? 0.0: ($rgb >= 1)? 1.0: double($rgb)}
      if {$m < $M} {
        set adjust 1
        set adjustC "(\$c-$m)/[expr double($M-$m)]"
      }
      if {$mRGB < $MRGB} {
        set adjust 1
        set adjustRGB "(\$rgb-$mRGB)/[expr double($MRGB-$mRGB)]"
      }
    }

    set newlist {}
    foreach c $list {
      set fixed [expr {[lindex $c 0] == "n"}]
      if {$adjust && !$fixed} {
        if {[string compare [lindex $c 0] [lindex [lindex $c 0] 0]] == 0} {
	  if {[llength $c] > 1} {
            set C {}
	    foreach rgb $c {lappend C [eval expr $adjustRGB]}
            while {[llength $C] < 3} {lappend C 0.0}
            lappend newlist "[lrange $C 0 2] 1.0"
	  } elseif {$c != ""} {
            set c [eval expr $adjustC]
	    lappend newlist "[lindex $RGB [expr int($c*$n)]] 1.0"
	  } else {lappend newlist {0.0 0.0 0.0 1.0}}
        } else {
          set newc {}
          foreach c $c {
	    if {[llength $c] > 1} {
              set C {}
	      foreach rgb $c {lappend C [eval expr $adjustRGB]}
              lappend newc "$C 1.0"
	    } else {
              set c [eval expr $adjustC]
	      lappend newc "[lindex $RGB [expr int($c*$n)]] 1.0"
	    }
          }
	  lappend newlist $newc
        }
      } else {
        if {$fixed} {set c [lindex $c 1]}
        if {[string compare [lindex $c 0] [lindex [lindex $c 0] 0]] == 0} {
	  if {[llength $c] == 3} {
	    lappend newlist "$c 1.0"
	  } else {
	    if {$c < 0} {set c 0} elseif {$c > 1} {set c 1}
	    lappend newlist "[lindex $RGB [expr int($c*$n)]] 1.0"
	  }
        } else {
          set newc {}
          foreach c $c {
	    if {[llength $c] == 3} {
	      lappend newc "$c 1.0"
	    } else {
	      if {$c < 0} {set c 0} elseif {$c > 1} {set c 1}
	      lappend newc "[lindex $RGB [expr int($c*$n)]] 1.0"
	    }
          }
	  lappend newlist $newc
        }
      }
    }
    return $newlist
  }

  Method Uncolored {} {
    Vars uncolored by
    set uncolored [expr {[string index $by 0] == " "}]
  }

  Method isColored {} {
    return [expr {[val by] != " "}]
  }

  Method isSolid {} {
    return [expr {[string index [val by] 0] == " "}]
  }
}
