Require label.tcl
Require widgets.tcl
Require button.tcl

Widgets Subclass CheckBoxes {ClassVar {window .checkboxes} {part CheckBox}}
CheckBoxes Window CheckBoxes

Widget Subclass CheckBox {
  Var value label
  ClassVar {window .checkboxes}

  Method Set {value {update true}} {
    set [var value] $value
    if {$update == "true"} {Self Update}
  }
  Method Get {} {return [val value]}

  Method BaseName {base} {
    Vars label
    set checkbox .checkboxes.x-[Self]
    $checkbox configure -text "$label $base"
  }


  Method Create {name val title} {
    Vars init value label
    set self [Self]
    set value $val
    set label $title
    set checkbox [_button(Button) .checkboxes top Check x-$self $title \
		      [var value] {} "$self Update"]
  }

  Method Configure {val title} {
    Vars label
    set label $title
    set checkbox .checkboxes.x-[Self]
    pack $checkbox -in .checkboxes -fill x
    $checkbox configure -text $title
  }

  Method Remove {checkbox} {destroy $checkbox}
}