Require oo.tcl
Require packdata.tcl


PackData Subclass AppearanceData {
  Var shading transparency lineWidth faces edges normals
  Var iShading iTransparency iLineWidth iFaces iEdges iNormals
  Var trans lineW
  ClassVar {default {flat 1.0 1 1 0 0  0 0 0 0 0 0  1.0 1}}
  ClassVar {data {shading transparency lineWidth faces edges normals
                  iShading iTransparency iLineWidth iFaces iEdges iNormals
                  trans lineW}}
  ClassVar {array _app}

  Method Restore {} {
    Parent Restore
    Self MenuCheck
  }

  Method MenuCheck {} {
    global _app
    foreach menu {Shading Transparency {Line Width} Faces Edges Normals} {
      regsub -all { } $menu {} var
      if $_app(i$var) {set state disabled} else {set state normal}
      .mbar.appearance.menu entryconfigure $menu -state $state
    }
  }

  Method Inherit {state current} {
    global _app
    foreach var {Shading Transparency LineWidth Faces Edges Normals} {
      if $current {set _app(i$var) $state} else {set [var i$var] $state}
    }
  }

  Method LineWidth {} {
    global _app
    Self SetLineWidth $_app(lineWidth)
    _name(Request) "Line Width:" $_app(lineWidth) "[Self] _LineWidth" "" \
      "a line width" "Line Width"
  }
  Method _LineWidth {} {
    global _name _app
    if {![regexp {^ *[0-9]+ *$} $_name(name)]} \
	{Error "Line width must be an integer"}
    Self SetLineWidth [string trim $_name(name)]
    Owner AutoApp
  }
  Method SetLineWidth {w} {
    global _app
    set _app(lineWidth) $w
    set _app(lineW) "other"
    if {![catch {.mbar.appearance.menu.width entryconfig "*$w"}]} \
       {set _app(lineW) $_app(lineWidth)}
  }

  Method Transparency {} {
    global _app
    set transparency [expr {(1.0-$_app(transparency))*100}]
    _SelectPercent Request "Transparency" $transparency "[Self] _Transparency"
  }
  Method _Transparency {percent} {
    global _app
    set _app(transparency) [expr {1.0-($percent/100.0)}]
    set _app(trans) "other"
    regsub {\.0*$} $percent {} percent
    if {![catch {.mbar.appearance.menu.trans entryconfig "*$percent%*"}]} \
	{set _app(trans) $_app(transparency)}
    Owner AutoApp
  }

  Method Write {file} {
    Vars shading transparency lineWidth faces edges normals
    Vars iShading iTransparency iLineWidth iFaces iEdges iNormals
    if !$iShading   {puts $file "   shading $shading"}
    if !$iLineWidth {puts $file "   linewidth $lineWidth"}
    if !$iFaces \
	{if {$faces} {puts $file "   +face"}   else {puts $file "   -face"}}
    if !$iEdges \
	{if {$edges} {puts $file "   +edge"}   else {puts $file "   -edge"}}
    if !$iNormals \
	{if {$normals} {puts $file "   +normal"} \
	     else {puts $file "   -normal"}}
    if !$iTransparency {
      if {$transparency != 1.0} {
	puts $file "   +*transparent"
	puts $file "   material { *alpha $transparency }"
      }
    }
    set color [Owner Color get by]
    if {[string index $color 0] == " " && $color != " "} {
      set color [eval $color]
      puts $file "   material { *diffuse $color }"
    }
  }
}

