proc _video(Begin) {} {
  global _video _action _file
  if {$_action(video)} {
    set _video(file) [open $_file(video) w]
    _video(Header)
  } else {
    set _video(file) [open "/dev/null" w]
  }
  set _video(n) 0
}

proc _video(End) {} {
  global _video _action
  if {$_action(video)} _video(Footer)
  close $_video(file)
  if {$_action(video)} _video(Make)
}

proc _video(Header) {} {}

proc _video(Footer) {} {
  global _frame _video
  if {$_frame(fading)} {puts $_video(file) " $_frame(last)"}
  _status(Message) "Total frames: $_video(n)"
}

proc _video(Make) {} {
  global _frame _file _video
  set _file(record)    "$_file(base).record"
  set _file(log)       "$_file(base).log"
  set file [open $_file(record) w]
  puts $file "\#! /bin/sh"
  puts $file "exec >> $_file(log) 2>&1"
  puts $file "echo Beginning at `date` with: '\$@'"
  puts $file "heave -v -i 00:00:01:00 -g1.0 \"\$@\" -r $_file(video)"
  puts $file "echo Done at `date` with: '\$@'"
  close $file
  exec /bin/chmod +x $_file(record)
  _status(Message) \
    "\nExecute the file '$_file(record)' from a shell to record the video"
}

proc _video(Frame) {name} {
  global _video _frame _action
  if {$_frame(fading)} {puts $_video(file) " $name"; set _frame(f) -1}
  set f [expr int($_frame(pause) / $_frame(speed))]
  if {$f < 1} {set f 1}
  if {$f != $_frame(f)} {set _frame(f) $f; puts $_video(file) "-f $f"}
  puts $_video(file) " $name"; incr _video(n) $_frame(f)
  if {! $_action(frames)} {_status(Message) " $name"}
}

proc _video(Pause) {frames} {
  global _video _frame
  incr _video(n) $frames
  puts $_video(file) "-f $frames\n $_frame(last)"
}