Require transform.tcl
Require bind.tcl


set _script(frameChanged) {WindowSize}
set _script(illegal) {Fade Scene Script}

proc _script(Begin) {} {
  global _script _transform
  if [info exists _script(oldDefault)] \
      {set _transform(default) $_script(oldDefault)}
  set changed $_script(frameChanged)
  set illegal $_script(illegal)
  catch {unset _script}
  set _script(frameChanged) $changed
  set _script(illegal) $illegal
  set _script(running) 0
}

proc Script {action args} {
  if {[info procs _script(_$action)] != ""} {
    set message [_Uplevel _script(_$action) $args]
  } else {Error "Script action \"$action\" not known"}
  return $message
}

proc _script(_for) {object args} {
  global _script
  if {$args == ""} {
    if ![info exists _script(S:$object)] \
	{return -code error "No script for object \"$object\""}
  } else {
    set lines [_script(Lines) [join $args \n]]
    if [info exists _script(S:$object)] \
	{set lines [concat $_script(S:$object) $lines]}
    set _script(S:$object) $lines
  }
  return [join $_script(S:$object) \n]
}

proc _script(_clear) {object} {
  global _script
  catch {unset _script(S:$object)}
  return  
}

proc _script(_group) {name args} {
  global _script
  if {[llength $args] == 1} {set args [lindex $args 0]}
  if {$args == ""} {catch {unset _script(G:$name)}} \
      else {set _script(G:$name) $args}
}

proc Until {cue action args} {
  return -code error "\"Until\" can only be used inside a \"Script\" command"
}

proc Cue {name} {
  return -code error "\"Cue\" can only be used inside a \"Script\" command"
}

proc _script(Lines) {script} {
  set lines {}; set command {}
  foreach line [split $script \n] {
    if {$line != ""} {
      if {$command == ""} {set command $line} \
	  else {set command [join [list $command $line] \n]}
      if [info complete $command] {
	lappend lines $command
	set command {}
      }
    }
  }
  if {$command != ""} {return -code error "Incomplete command \"$command\""}
  return $lines
}

proc _script(_action) {} {
  uplevel _script(Count)
  uplevel _script(Action)
}

proc _script(Count) {} {
  global _script _frame
  set changed "([join $_script(frameChanged) |])"
  set illegal "([join $_script(illegal) |])"

  foreach name [array names _script S:*] {
    set name [string range $name 2 end]
    set count($name) 0
    set index($name) 0
    set _script(F:$name) $_frame(last)
  }
  set progressed 1
  while {([set names [array names index]] != "") && $progressed} {
    foreach name $names {
      set running 1
      while {$running} {
	if {$index($name) >= [llength $_script(S:$name)]} {
	  unset index($name)
	  set running 0
	} else {
	  set progressed 0
	  set line [lindex $_script(S:$name) $index($name)]
	  set command [lindex $line 0]
	  if {$command == "Until"} {
	    set running [_script(Until) $name [lrange $line 1 end]]
	    if {$running} {
	      incr index($name)
	      incr progressed
	    }
	  } else {
	    if {[info procs _script(Count:$command)] != ""} {
	      set n [_script(Count:$command) $name [lrange $line 1 end]]
	      if {$n > 0} {
		incr count($name) $n
		set _script(F:$name) 1
	      }
	    } elseif [regexp "^$illegal\$" $command] {
	      return -code error "Command \"$command\" is illegal in a Script"
	    } elseif [regexp "^$changed\$" $command] {
	      set _script(F:$name) ""
	    }
	    incr index($name)
	    incr progressed
	  }
	}
      }
    }
  }
  if {!$progressed} {
    set name [lindex [array names index] 0]
    set cue [lindex [lindex $_script(S:$name) $index($name)] 1]
    Error "Can't resolve \"Until $cue\" in script for \"$name\""
  }
}

proc _script(Until) {name line} {
  global _script
  if [catch {_bind(Values) {cue command args} $line Until} message] \
      {return -code error $message}
  if ![info exists _script(Q:$cue)] {return 0}
  if {[info proc _script(Until:$command)] == ""} \
      {Error "Command \"$command\" can not be used with \"Until\"\
                in script for \"$name\""}
  upvar count($name) count
  set n [expr $_script(Q:$cue) - $count]
  if {$n <= 0} {Error "\"Until $cue\" in Script for \"$name\"\
                   is for a cue that has already occured"}
  _script(Replace) $name [_script(Until:$command) $name $args $n]
  set count $_script(Q:$cue)
  return 1
}

proc _script(Replace) {name line} {
  upvar 2 _script(S:$name) script
  upvar 2 index($name) index
  set script [lreplace $script $index $index $line]
}

proc _script(Count:Cue) {name values} {
  global _script
  upvar count($name) count
  upvar index($name) index
  if [catch {_bind(Values) {id {n 0}} $values Cue} message] \
      {return -code error $message}
  if [info exists _script(Q:$id)] \
      {Error "Cue \"$id\" in Script for \"$name\" is already in use"}
  set _script(Q:$id) $count
  incr _script(Q:$id) [uplevel 2 "expr $n"]
  if {$_script(Q:$id) < 0} {set _script(Q:$id) 0}
  set _script(S:$name) [lreplace $_script(S:$name) $index $index]
  incr index -1
}



proc _script(Action) {} {
  global _script _transform _frame _scene
  set _script(oldDefault) $_transform(default)
  set _script(running) 1
  set _script(frames) 0
  foreach name [array names _script S:*] \
      {set _script(F:[string range $name 2 end]) $_frame(last)}
  while {[set names [array names _script S:*]] != ""} {
    set ran 0
    foreach name $names {
      set name [string range $name 2 end]
      if ![info exists _script(G:$name)] {set _transform(default) $name} \
	  else {set _transform(default) $_script(G:$name)}
      if {[llength $_script(S:$name)] == 0} {unset _script(S:$name)} \
	  else {incr ran [uplevel _script(Run) $name]}
    }
    if {$ran > 0} {
      set _script(running) 0
      incr _script(frames)
      if {$_scene(shooting)} SaveFrame
      set _script(running) 1
    }
  }
  set _transform(default) $_script(oldDefault); unset _script(oldDefault)
  set _script(running) 0
  if {!$_scene(shooting)} \
      {_status(Message) "  Script ($_script(frames) frames skipped)"}
}

proc _script(Run) {name} {
  global _script
  set running 1; set count 0
  set changed "([join $_script(frameChanged) |])"
  while {$running && [llength $_script(S:$name)] > 0} {
    set line [lindex $_script(S:$name) 0]
    set command [lindex $line 0]
    if {[info procs _script(Action:$command)] != ""} {
      set running [_script(Action:$command) $name [lrange $line 1 end]]
      incr count
    } elseif {[string index $command 0] == "\#"} {
      set _script(S:$name) [lrange $_script(S:$name) 1 end]
    } else {
      uplevel $line; incr count
      set _script(S:$name) [lrange $_script(S:$name) 1 end]
      if [regexp "^$changed\$" $command] {set _script(F:$name) ""}
    }
  }
  return $count
}

proc _script(HandleAction) {name init script end} {
  global _script; upvar i i; upvar n n
  if [info exists _script(N:$name)] {
    set n [lindex $_script(N:$name) 0]
    set i [lindex $_script(N:$name) 1]
  } else {
    uplevel $init
    set _script(N:$name) [list $n $i]
  }
  uplevel $script
  incr i
  set _script(N:$name) [list $n $i]
  if {$i > $n} {
    unset _script(N:$name)
    set _script(S:$name) [lrange $_script(S:$name) 1 end]
    uplevel $end
  }
}



proc _script(Count:Pause) {name values} {
  global _script _frame
  if [catch {_bind(Values) {n} $values Pause} err] {return -code error $err}
  set n [uplevel 2 "expr ($n) * $_frame(resolution)"]
  set n [expr int($n / double($_frame(speed)))]
  if {$n < 1} {set n 0}
  _script(Replace) $name "Pause $n"
  return $n
}

proc _script(Until:Pause) {name values n} {
  return [concat Pause $n $values]
}

proc _script(Action:Pause) {name values} {
  global _script _frame
  if [catch {_bind(Values) {n} $values Pause} err] {return -code error $err}
  _script(HandleAction) $name {
    set i 1
    if {$n < 1} {return -code return 1}
  } {} {}
  set _script(F:$name) 1
  return 0
}



proc _script(Count:Loop) {name values} {
  global _script _frame
  set zero [expr {$_script(F:$name) != ""}]
  set n [lindex $values 0]; set values [lrange $values 1 end]
  if [catch {_bind(All) "!!saveframes {!zero 1 0 $zero} !skip" \
		 {body} $values Loop} message] {return -code error $message}
  set n [uplevel 2 "expr $n"]
  set n [expr int($n * $_frame(resolution))]
  if {$n < 1} {set n $zero}
  _script(Replace) $name [concat Loop $n $values]
  if {$zero == 0} {incr n}
  return $n
}

proc _script(Until:Loop) {name values n} {
  global _script _frame
  set zero [expr {$_script(F:$name) != ""}]
  if [catch {_bind(All) "!!saveframes {!zero 1 0 $zero} !skip" \
		 {body} $values Loop} message] {return -code error $message}
  if {$zero == 0} {incr n -1}
  return [concat Loop $n $values]
}

proc _script(Action:Loop) {name values} {
  global _script _loop
  global errorInfo errorCode
  set zero [expr {$_script(F:$name) != ""}]
  set n [lindex $values 0]; set values [lrange $values 1 end]
  if [catch {_bind(All) "!!saveframes {!zero 1 0 $zero} !skip" \
		 {body} $values Loop} message] {return -code error $message}
  _script(HandleAction) $name {
    set i $zero
    if {$n < 1} {if {!$zero} {return -code return 1}}
  } {
    lappend _loop(count) $i
    lappend _loop(max)   $n
    upvar 2 _loop(message) string
    set code [uplevel [list catch $body _loop(message)]]
    set _loop(count) [lreplace $_loop(count) end end]
    set _loop(max)   [lreplace $_loop(max) end end]
    if {$code != 0} {set $i [expr $n+1]}
  } {}
  switch $code {
    0 {} 3 {} 4 {}
    2 {return -code error "Can't return from inside a loop in a Script"}
    1 {return -code error -errorcode $errorCode -errorinfo $errorInfo $string}
    default {return -code $code $string}
  }
  set _script(F:$name) $saveframes
  return [expr !$saveframes]
}



proc _script(Count:SaveFrame) {name values} {
  if {$values != ""} \
    {return -code error "SaveFrame called with too many arguments"}
  return 1
}

proc _script(Action:SaveFrame) {name values} {
  global _script
  if {$values != ""} \
    {return -code error "SaveFrame called with too many arguments"}
  set _script(S:$name) [lrange $_script(S:$name) 1 end]
  set _script(F:$name) 1
  return 0
}
