proc _scene(Begin) {} {
  global _scene _scenes
  catch {unset _sdata}
  set _scene(list)  {}
  set _scene(n) -1
  _scene(Init) "scene-0"
}

proc Scene {{title ""}} {
  global _scene _frame
  set _sdata($_scene(title)) "$_scene(n) $_frame(n)"
  _scene(Init) $title
  _status(Message) "--------------------------------"
  if {$_scene(shooting)} {_status(Message) "Scene:  $_scene(title)"} \
                    else {_status(Message) "Scene:  $_scene(title) (skipped)"}
}

proc _scene(Init) {title} {
  global _scene _scenes _frame _action _options

  incr _scene(n); set _frame(n) 0
  if {$title == ""} {set title "scene-$_scene(n)"}
  set _scene(title) $title
  lappend _scene(list) $title
  set _sdata($title) "$_scene(n) $_frame(n)"
  if ![info exists _scenes($title)] {set _scenes($title) $_scene(all)}
  set _scene(shooting) $_scenes($title)
  set _scene(skipped) 0
  set name [_scene(Name)]
  if {$_action(frames) && $_scene(shooting)} {
    set images [glob -nocomplain $name.*]
    while {$images != ""} {
      eval exec /bin/rm -f [lrange $images 0 100]
      set images [lreplace $images 0 100]
    }
  }
  if {$_options(stopAt) == "scene"} {Stop}
}

proc _scene(Name) {} {
  global _file _scene
  return "$_file(frameroot)/scene-$_scene(n)"
}

proc _scene(End) {} {
  global _scene _scenes
  set list {}
  foreach name $_scene(list) {lappend list [list $name $_scenes($name)]}
  return $list
}
