Require commands.tcl

proc _mpeg(Begin) {} {
  global _mpeg _action _file
  if {$_action(mpeg)} {
    set _mpeg(file) [open $_file(param) w]
    _mpeg(Header)
  } else {
    set _mpeg(file) [open "/dev/null" w]
  }
  set _mpeg(n) 0
}

proc _mpeg(End) {} {
  global _mpeg _action
  if {$_action(mpeg)} _mpeg(Footer)
  close $_mpeg(file)
  if {$_action(mpeg) && $_mpeg(n) > 0} _mpeg(Make)
}

proc _mpeg(Header) {} {
  global _mpeg _file
  puts $_mpeg(file) "OUTPUT                   $_file(mpeg)"
  puts $_mpeg(file) "INPUT_DIR                $_file(frameroot)"
  puts $_mpeg(file) "BASE_FILE_FORMAT         PNM"
  puts $_mpeg(file) "INPUT_CONVERT            [_cmd(mpegConvert)]"
  puts $_mpeg(file) "SLICES_PER_FRAME         1"
  puts $_mpeg(file) "PIXEL                    [string toupper $_mpeg(pixel)]"
  puts $_mpeg(file) "RANGE                    $_mpeg(range)"
  puts $_mpeg(file) "PSEARCH_ALG              [string toupper $_mpeg(algP)]"
  puts $_mpeg(file) "BSEARCH_ALG              [string toupper $_mpeg(algB)]"
  puts $_mpeg(file) "IQSCALE                  $_mpeg(IQ)"
  puts $_mpeg(file) "PQSCALE                  $_mpeg(PQ)"
  puts $_mpeg(file) "BQSCALE                  $_mpeg(BQ)"
  puts $_mpeg(file) "REFERENCE_FRAME          DECODED"
  puts $_mpeg(file) "FORCE_ENCODE_LAST_FRAME  TRUE"
  puts $_mpeg(file) "PATTERN                  [string toupper $_mpeg(pattern)]"
  puts $_mpeg(file) "GOP_SIZE                 [string length $_mpeg(pattern)]"
  puts $_mpeg(file) ""
  puts $_mpeg(file) "INPUT"
}

proc _mpeg(Footer) {} {
  global _mpeg
  puts $_mpeg(file) "END_INPUT"
  _status(Message) "Total frames: $_mpeg(n)"
}

proc _mpeg(Make) {} {
  global _mpeg _file
  _status(Message) "\n================================"
  _status(Message) "================================\n"
  _status(Message) "Making MPEG file"
  set cmd [_cmd(mpegEncode) $_file(param)]
  set encode [open "| /bin/sh -c \"$cmd \"" r]
  while {! [eof $encode]} {gets $encode line; _status(Message) $line}
  close $encode
  _status(Message) "================================"
  _status(Message) "MPEG movie complete"
  if {![catch {set size [file size $_file(mpeg)]}]} {
     set size [expr int($size/1024.0)]
     _status(Message) "File size: $size Kb"
  }
  _status(Message) "\nUse the TOOLS/MPEG VIEWER menu to see it"
}

proc _mpeg(Frame) {name} {
  global _mpeg _action
  puts $_mpeg(file) [file tail $name]; incr _mpeg(n)
  if {! $_action(frames)} {_status(Message) " $name"}
}

proc _mpeg(Pause) {frames} {
  global _mpeg _action _frame
  incr _mpeg(n) $frames
  if {$_action(mpeg)} {
    set name [file tail $_frame(last)]
    while {[incr frames -1] > 0} {puts $_mpeg(file) $name}
  }
}