Require bind.tcl

proc _loop(Begin) {} {
  global _loop
  set _loop(count) {}
  set _loop(max)   {}
}

proc Loop {count args} {
  global _loop _frame _scene
  global errorInfo errorCode
  set zero [expr {$_frame(last) != ""}]
  if [catch {_bind(All) "!!saveframes {!zero 1 0 $zero} {!skip 0 1 {0 }}" \
		 {body} $args Loop} message] {return -code error $message}
  set count [uplevel "expr int(($count) * $_frame(resolution))"]
  if {$skip == 1 || (!$_scene(shooting) && [string length $skip] == 2)} \
      {set count 1; set zero 0}
  set code 0; upvar _loop(message) string
  lappend _loop(count) $zero
  lappend _loop(max)   $count
  for {set i $zero} {$i <= $count && $code == 0} {incr i} {
    set _loop(count) [lreplace $_loop(count) end end $i] 
    set code [uplevel [list catch $body _loop(message)]]
    _status(Check); if {$saveframes} {SaveFrame}
  }
  set _loop(count) [lreplace $_loop(count) end end]
  set _loop(max)   [lreplace $_loop(max) end end]
  switch $code {
    0 {} 3 {} 4 {}
    2 {return -code return $string}
    1 {return -code error -errorcode $errorCode -errorinfo $errorInfo $string}
    default {return -code $code $string}
  }
}

proc _loop(CountMax) {{n 0}} {
  global _loop
  if ![regsub {^ *\# *} $n {} n] {set n [expr [llength $_loop(count)]-($n)-1]}
  return [list [lindex $_loop(count) $n] [lindex $_loop(max) $n]]
}

proc Count {{n 0}} {return [lindex [_loop(CountMax) $n] 0]}
proc Max   {{n 0}} {return [lindex [_loop(CountMax) $n] 1]}

proc Frac {x {n 0}} {return [uplevel "expr ($x)/double([Max $n])"]}

proc Percent {m M {n 0}} {
  set m [uplevel "expr $m"]; set M [uplevel "expr $M"]
  set cm [_loop(CountMax) $n]; set i [lindex $cm 0]; set max [lindex $cm 1]
  if {$max == 1} {return $M}
  return [expr $m + (($M-$m) * $i / double($max))]
}
