set _frame(perSecond)  30

proc _driver(Begin) {} {}
proc _driver(End) {} {}
proc _driver(BeginFrame) {name} {}
proc _driver(EndFrame) {name} {}
proc _driver(SkipFrame) {name} {}
proc _driver(Pause) {frames} {}
proc _driver(Fade) {frames} {}

proc _driver(BeginSnapshot) {{frame 0}} {}
proc _driver(Snapshot) {image file type w h colors dither} {}
proc _driver(Convert)  {image file type w h colors dither} {}
proc _driver(EndSnapshot) {{frame 0}} {}
set _driver(tmpfile)   "/tmp/sm.tmp"

proc _driver(Sleep) {seconds {force 0}} \
    {if {$force} {after [expr int(($seconds)*1000)}}


proc _frame(Begin) {} {
  global _frame _image
  set _frame(n) 0
  set _frame(last) ""
  set _frame(fading) 0
  set _frame(f) -1
  set _frame(skipped) 0
  if {$_frame(speed) <= 0} {set _frame(speed) 1}
  if {$_image(type) == ""} {set $_image(type) "gif"}
  if {$_image(colors) == "millions"} {set _image(colors) ""}
}

proc _frame(Changed) {} {
  global _frame
  set _frame(last) ""
}

proc _frame(Name) {} {
  global _frame
  return "[_scene(Name)].[format %04d $_frame(n)]"
}

proc _frame(Sleep) {frames {force 0}} {
  global _frame _action
  _status(Check)
  set time [expr double($frames) / $_frame(speed) / $_frame(perSecond)]
  if {$time > 0 && ! $_action(frames)} {_driver(Sleep) $time $force}
}

proc SaveFrame {} {
  global _frame _scene _action _image _driver _options _script
  set name [_frame(Name)]
  if {$_script(running)} {Error "Illegal use of SaveFrame within a Script"}
  if {$_scene(shooting)} {
    _driver(BeginFrame) $name
    if {$_action(video)}   {_video(Frame) $name}
    if {$_action(animGIF)} {_animGIF(Frame) $name}
    if {$_action(mpeg)}    {_mpeg(Frame) $name}
    if {$_action(frames)}  {
      _status(Message) " $name"
      set tmpfile $_driver(tmpfile); set type $_image(type)
      set colors $_image(colors); set dither $_image(dither)
      set w $_image(w); set W $_image(W); set h $_image(h); set H $_image(H)
      _driver(BeginSnapshot) 1
      _driver(Snapshot) $tmpfile $name $type $W $H $colors $dither
      _driver(EndSnapshot) 1
      _driver(Convert)  $tmpfile $name $type $w $h $colors $dither
      if {$tmpfile != $name} {exec /bin/rm -f $tmpfile}
    }
    _frame(Sleep) $_frame(pause)
    set _frame(last) $name
    _driver(EndFrame) $name
  } else {
    _driver(SkipFrame) $name
    _status(Message) "  $name (skipped)"
    incr _frame(skipped)
  }
  incr _frame(n)
  set _frame(fading) 0
  if {$_options(stopAt) == "frame"} Stop else {Stop step}
}

proc Snapshot {name {w ""} {h ""}} {
  global _image _file _driver _action _scene
  if {$_scene(shooting) && $_action(snapshots)} {
    if {[string index $name 0] != "/"} {set name $_file(imageroot)/$name}
    set type [string range [string tolower [file extension $name]] 1 end]
    if {$type == ""} {set type "gif"}
    set colors $_image(colors); set dither $_image(dither)
    set tmpfile $_driver(tmpfile)
    if {$h == ""} {
      set r $w; set w $_image(w); set h $_image(h)
      if {$r != ""} {
	if [regsub {%$} $r {} r] {set r [expr $r/100]}
	set w [expr int(($r)*($w))]
	set h [expr int(($r)*($h))]
      }
    }
    set W $w; set H $h; _image(_ScaleSize) W H
    _status(Message) " $name (snapshot)"
    _driver(BeginSnapshot)
    _driver(Snapshot) $tmpfile $name $type $W $H $colors $dither
    _driver(EndSnapshot)
    _driver(Convert)  $tmpfile $name $type $w $h $colors $dither
    exec /bin/rm -f $tmpfile
    _status(Check)
  }
}

proc Pause {frames} {
  global _frame _scene
  if {$_scene(shooting)} {
    set sleep [uplevel "expr ($frames) * $_frame(resolution)"]
    set frames [expr int($sleep / double($_frame(speed)))]
    if {$frames > 0} {
      if {$_frame(last) == ""} SaveFrame
      _driver(Pause)  $frames
      _mpeg(Pause)    $frames
      _animGIF(Pause) $frames
      _video(Pause)   $frames
      set _frame(f)   $frames
    }
    _frame(Sleep) $sleep 1
  }
}

proc Fade {frames} {
  global _frame _scene _video
  if {$_scene(shooting)} {
    if {$_frame(last) == ""} SaveFrame
    set f [uplevel "expr int(($frames) / $_frame(speed))"]
    _driver(Fade) $f
    if {$_frame(fading)} {puts $_video(file) " $_frame(last)"}
    puts $_video(file) "-fade $f\n $_frame(last)"
    incr _video(n) $f
    _frame(Sleep) $frames 1
    set _frame(fading) 1
  }
}
