Require commands.tcl

proc _animGIF(AddFile) {name} {
  global _animGIF
  lappend _animGIF(files) [file tail $name]
}

proc _animGIF(Begin) {} {
  global _animGIF
  set _animGIF(files) {}
}

proc _animGIF(End) {} {
  global _animGIF _action
  if {$_action(animGIF) && $_animGIF(files) != ""} _animGIF(Make)
}
proc _animGIF(Make) {} {
  global _animGIF _file
  _status(Message) "\n================================"
  _status(Message) "================================\n"
  _status(Message) "Making Animated GIF file"
  set encode [open "| /bin/sh -c \"[_cmd(gifMerge)]\"" r]
  while {! [eof $encode]} {gets $encode line; _status(Message) $line}
  close $encode
  _status(Message) "================================"
  _status(Message) "Animated GIF complete"
  if {![catch {set size [file size $_file(animGIF)]}]} {
     set size [expr int($size/1024.0)]
     _status(Message) "File size: $size Kb"
  }
}

proc _animGIF(Frame) {name} {
  global _animGIF _action
  _animGIF(AddFile) $name
  if {! $_action(frames)} {_status(Message) " $name"}
}

proc _animGIF(Pause) {frames} {
  global _animGIF _action _frame
  if {$_action(animGIF)} \
    {while {[incr frames -1] > 0} {_animGIF(AddFile) $_frame(last)}}
}
