Require matrix.tcl
Require bind.tcl
Require interpolate.tcl

proc _driver(GetTransform) {object} {}
proc _driver(SetTransform) {object M} {}

set _transform(default)  "world"

proc _transform(Get) {{object ""}} {
  global _matrix _transform _action
  if {!$_action(driver)} {return $_matrix(I)}
  if {$object == ""} {set object $_transform(default)}
  return [_driver(GetTransform) $object]
}

proc _transform(Set) {M {object ""}} {
  global _transform _action
  if {!$_action(driver)} return
  if {$object == ""} {set object $_transform(default)}
  _driver(SetTransform) $object $M
}

proc Transform {M args} {
  global _action _transform
  if [catch {_bind(Rest) {{object ""}} {!parent} $args Transform} message] \
      {return -code error $message}
  
  _frame(Changed)
  if {!$_action(driver)} return
  _matrix(GetDimension)
  set M [uplevel $M]
  if {$object == ""} {set object $_transform(default)}
  foreach obj $object {
    if {$parent} {
      _transform(Set) [_matrix(Mult) $M [_transform(Get) $obj]] $obj
    } else {
      _transform(Set) [_matrix(Mult) [_transform(Get) $obj] $M] $obj
    }
  }
}

proc Sequence {MM n args} {
  global _action _transform _scene _frame _video _mpeg _options
  set zero [expr {$_frame(last) == ""}]
  if [catch {_bind(Rest) {{object ""}} \
		 "!parent {!zero 0 1 $zero} {interp= linear}" \
		 $args Sequence} message] {return -code error $message}
  
  set n [uplevel "expr int(($n) * $_frame(resolution))"]
  if {$object == ""} {set object $_transform(default)}
  if {$_scene(shooting)} {
    if {$zero} SaveFrame
    foreach obj $object {set T($obj) [_transform(Get) $obj]}
    for {set i 1} {$i <= $n} {incr i} {
      set M [uplevel $MM -amount [_interpolate(Select) $interp $i $n]]
      foreach obj $object {
	if {$parent} {_transform(Set) [_matrix(Mult) $M $T($obj)] $obj} \
	        else {_transform(Set) [_matrix(Mult) $T($obj) $M] $obj}
      }
      SaveFrame
    }
    if {$_options(stopAt) == "sequence"} Stop
  } else {
    incr _frame(n) $n; incr _video(n) $n; incr _mpeg(n) $n
    incr _frame(skipped) $n
    _status(Message) " Sequence ($n frames skipped)"
    set M [concat $MM -amount [_interpolate(Select) $interp 1 1]]
    uplevel [list Transform $M $object]
  }
}

proc Path {path args} {
  global _action _transform _matrix _scene _frame _options _video _mpeg
  set zero [expr {$_frame(last) == ""}]
  if [catch {_bind(Rest) {{object ""}} "!parent {!zero 0 1 $zero}" \
		 $args Transform} message] {return -code error $message}
  
  if {$object == ""} {set object $_transform(default)}
  if {[llength [lindex $path 0]] == 1} {set path [list $path]}

  foreach p $path {
    _bind(Values) {n {t ""} {r ""} {s ""}} $p "{$p}"
    set n [uplevel "expr ($n) * $_frame(resolution)"]
    if {!$_scene(shooting)} {
      incr _frame(n) $n; incr _video(n) $n; incr _mpeg(n) $n
      incr _frame(skipped) $n
      _status(Message) " Path ($n frames skipped)"
      set n 1
    }
    set amount [expr 1/double($n)]
    if {$t == ""} {set M $_matrix(I)} \
	else {set M [uplevel [list Translate $t -amount $n]]}
    if {$r != ""} {set M [_matrix(Mult) $M [uplevel $r -amount $amount]]}
    if {$s != ""} {set M [_matrix(Mult) $M [uplevel Scale $s -amount $amount]]}
    if {$zero} SaveFrame
    foreach obj $object {set T($obj) [_transform(Get) $obj]}
    for {set i 0} {$i < $n} {incr i} {
      foreach obj $object {
	if {$parent} {
	  set O [_matrix(Origin) $T($obj)]
	  set T($obj) [_matrix(Mult) [_matrix(Offset) $M $O] $T($obj)]
	} else {
	  set T($obj) [_matrix(Mult) $T($obj) $M]
	}
	_transform(Set) $T($obj) $obj
      }
      SaveFrame
    }
    if {$_scene(shooting) && $_options(stopAt) == "sequence"} Stop
  }
}