Require option.tcl

_option(Add) text(font)    "*-courier-medium-r-normal--*-180-*" 
_option(Add) text(relief)  groove 
_option(Add) text(bd)	   3 
set _text(font)    [option get . text(font) *]
set _text(relief)  [option get . text(relief) *]
set _text(bd)      [option get . text(bd) *]

_option(Add) Entry.font $_text(font) 
_option(Add) Entry.selectBorderWidth 0 
_option(Add) Entry.selectBackground white 

_option(Add) Text.font $_text(font) 
_option(Add) Text.selectBorderWidth 0 
_option(Add) Text.selectBackground white 


proc _text(Scrollable) {parent name w h {pad 2} {placement top} {hscroll 0}} {
  global _text tk_version
  if {$parent == "."} {set text .$name} else {set text $parent.$name}
  set frame ${text}(frame)
  set box ${text}(box)
  set scroll ${text}(scroll)
  _option(Set) $frame relief $_text(relief)
  _option(Set) $frame borderWidth $_text(bd)
  _option(Set) $text width $w
  _option(Set) $text height $h
  frame $frame; frame $box -relief flat -borderwidth 0
  text $text -yscrollcommand [list $scroll set] -padx 5 -pady 3 -wrap word
  scrollbar $scroll -command [list $text yview]
  pack $scroll -in $box -side right -fill y
  pack $text -in $box -fill both -expand true
  pack $box -in $frame -fill both -expand true -padx $pad -pady $pad
  pack $frame -in $parent -side $placement -fill both -expand true
  if {$hscroll} {
    set hscroll $box.hscroll
    set hbox    ${hscroll}(box)
    set hcorner ${hscroll}(corner)
    frame $hbox -relief flat -borderwidth 0
    scrollbar $hscroll -orient horizontal -command [list $text xview]
    set bd [$scroll cget -borderwidth]
    set wd [expr [winfo reqwidth $scroll] - 2 * $bd]
    if {$tk_version >= 8.0} \
      {incr wd [expr 2*[$scroll cget -highlightthickness]]}
    _option(Set) $hcorner relief [$scroll cget -relief]
    _option(Set) $hcorner borderWidth $bd
    _option(Set) $hcorner width $wd
    frame $hcorner
    set pad [$scroll cget -highlightthicknes]
    pack $hscroll -in $hbox -side left -fill x -expand true
    pack $hcorner -in $hbox -side right -fill y -padx $pad -pady $pad
    pack $hbox -side bottom -fill x -before $scroll
    $text configure -wrap none -xscrollcommand [list $hscroll set]
  }
  return $text
}


#
#  Make ESCAPE work like META for these
#
bind Text <Escape><greater> [join [list [bind Text <Meta-greater>] break] "; "]
bind Text <Escape>w [join [list [bind Text <Meta-w>] break] "; "]

#
#  Make CTRL-D work like forward delete
#
bind Entry <Control-d> [bind Entry <Delete>]
bind Text <Control-d>  [bind Text <Delete>]

