Require input.tcl

if {![info exists _program(id)]} {set _program(id) [winfo name .]}

set _status(signal)  0
set _status(stop)    0
set _status(stopped) 0
set _status(step)    0
set _status(cancel)  0
set _status(kill)    0
set _status(execute) 0
set _status(running) 0
set _status(send)    0
set _status(sends)   0
set _status(pattern) {^<< Status: +(.+) +>>$}
set _status(code)    STATUS_ERROR

proc _driver(Paused) {state} {}

proc _status(Check) {} {
  global _status
  update
  while {$_status(stop) && ! $_status(stopped) &&
	 ! $_status(cancel) && ! $_status(kill)} {
    set _status(stopped) 1
    set _status(signal)  0
    _status(Message) "  (Paused)"
    _status(Configure) {normal normal disabled normal} Paused
    _driver(Paused) 1
    tkwait variable _status(signal)
    _driver(Paused) 0
    _status(Configure) {disabled disabled normal normal} Running
    set _status(stopped) 0
  }
  if {$_status(kill)} {return -code error -errorcode $_status(code) "Killed"}
  if {$_status(cancel)} {
    set _status(cancel) 0
    return -code error -errorcode $_status(code) "Cancelled"
  }
}

proc _status(_Pause) {} {
  global _status
  set _status(stop)   1
  set _status(signal) 1
}

proc _status(_Continue) {} {
  global _status
  set _status(stop)   0
  set _status(step)   0
  set _status(signal) 1
}

proc _status(_Step) {} {
  global _status
  _status(_Continue)
  set _status(step)   1
}

proc _status(_Cancel) {} {
  global _status
  set _status(cancel) 1
  set _status(signal) 1
}

proc _status(_Kill) {} {
  global _status
  set _status(kill)   1
  set _status(signal) 1
}

proc _status(_Execute) {} {
  global _status
  set _status(execute) 1
  set _status(signal)  1
}

proc Print {args} {uplevel _status(Print) $args}

proc _status(Print) {args} {
  set line [join $args \n]
  _command(Print) "Message Print [string length $line]" $line
  _command(Sync)
  _status(Check)
  return
}

proc _status(Message) {args} {
  set line [join $args \n]
  _command(Print) "Message Print [string length $line] message" $line
  _command(Sync)
  _status(Check)
  return
}

proc _status(Error) {args} {
  set line [join $args \n]
  _status(Configure) {} "Crashed!"
  _command(Print) "Message Error [string length $line]" $line
  _command(Sync)
  _status(Check)
  return
}

proc _status(Configure) {buttons title} {
  global _program
  _command(Print) [list Message Configure $buttons "$_program(id): $title"]
}

proc _status(Run) {script {errorscript ""}} {
  global _status errorInfo errorCode
  
  set _status(kill) 0
  while {! $_status(kill)} {
    if {$_status(execute)} {
      set _status(running) 1
      set _status(sends)   0
      set _status(execute) 0
      set _status(stop)    0
      set _status(stopped) 0
      set _status(step)    0
      set _status(cancel)  0

      _command(Print) {Message Clear}
      _status(Configure) {disabled disabled normal normal} Running
      set code [uplevel \#0 [list catch $script _status(message)]]
      _status(Configure) {disabled disabled disabled disabled} Done

      switch $code {
	0 {} 2 {} 3 {} 4 {}
	default {
	  catch {eval $errorscript}
	  if {$errorCode == $_status(code)} {
	    catch {_status(Message) "  ($_status(message))"}
	    catch {_status(Configure) {} $_status(message)}
	  } else {
	    catch {_status(Error) $errorInfo}
	  }
	}
      }
      set _status(running) 0
    } else {
      set _status(signal) 0
      tkwait variable _status(signal)
    }
  }
}

proc _status(Receive) {script} {
  global _status _program errorInfo errorCode
  if {$_status(running) && ! $_status(stopped)} {
    return -code error -errorcode STATUS_NOTSTOPPED \
      "$_program is executing a script"
  }
  if {!$_status(running) && !$_status(sends)} {
    _command(Print) {Message Clear}
    set _status(sends) 1
  }

  set _status(stop)    0
  set _status(stopped) 0
  set _status(step)    0
  set _status(cancel)  0

  _status(Configure) {disabled disabled normal normal} Running
  set _status(send) 1
  set code [uplevel \#0 [list catch $script _status(message)]]
  set _status(send) 0
  if {$_status(running)} {
    _status(Configure) {normal normal disabled disabled} Paused
    set _status(stop) 1
    set _status(stopped) 1
  } else {
    _status(Configure) {disabled disabled disabled disabled} Done
  }

  return -code $code -errorinfo $errorInfo \
    -errorcode $errorCode $_status(message)
}


proc Stop {{step ""}} {
  global _status
  if {$step == ""} {
    _status(_Pause)
  } elseif {$_status(step)} {
    set _status(step) 0
    _status(_Pause)
  }
  _status(Check)
}