#
#  Code to implement sends between wish versions 3 and 4
#

set _wish(3.6) "/usr/local/bin/wish3.6"
set _wish(4.0) "/usr/local/bin/wish"


#
#  Call  send3  to send a script from a TK4.0 to a TK3.6 application
#
proc send3 {application script} {_send 3.6 $application $script}


#
#  Call  send4  to send a script from a TK3.6 to a TK4.0 application
#
proc send4 {application script} {_send 4.0 $application $script}


#
#  Main routine for sending between versions
#
#  Open a wish of the correct versino to do the send for us
#  and have it send us back the result codes that it gets
#
proc _send {version application script} {
  global _wish
  if [catch {set wish $_wish($version)}] {
    return -code error "bad wish version number '$version'"
  }
  set pipe [open "| $wish" r+]
  regsub -all {(^|[^\\])([$"\\])} $application {\1\\\2} application
  puts $pipe "
    wm withdraw .
    set code \[catch {send \"$application\" {$script}} message\]
    puts \$code
    puts \[string length \$message\]
    puts \$message
    puts \$errorCode
    puts \[string length \$errorInfo\]
    puts \$errorInfo
    exit
  "
  flush $pipe
  gets $pipe code
  gets $pipe n; set message [read $pipe $n]; read $pipe 1;   # read newline
  gets $pipe eCode
  gets $pipe n; set eInfo [read $pipe $n]; read $pipe 1
  catch {close $pipe}
  return -code $code -errorcode $eCode -errorinfo $eInfo $message
}
