set _image(.mpeg.size)  288x288
set _image(.video.size) 640x480
set _image(.scale)   "{} 1 2 1.5 [expr 4.0/3.0]"
set _image(.unscale) "{} 1 .5 [expr 2.0/3.0] .75"

proc _image(_ScaleSize) {W H} {
  global _image
  upvar $W w; upvar $H h
  set _image(r) [lindex $_image(.scale) $_image(scale)]
  set w [expr int($_image(r) * $w + 0.5)]
  set h [expr int($_image(r) * $h + 0.5)]
}

proc _image(_UnscaleSize) {W H} {
  global _image
  upvar $W w; upvar $H h
  set r [lindex $_image(.unscale) $_image(scale)]
  set w [expr int($w * $r + 0.5)]
  set h [expr int($h * $r + 0.5)]
}
