Require button.tcl
Require label.tcl
Require text.tcl
Require option.tcl

_option(Add) rgb.Scale.length 300
_option(Add) rgb.color.relief sunken
_option(Add) rgb.color.borderWidth 3
_option(Add) rgb.color.box.width 50

ooRoot Instance _SelectRGB {
  Var color original
  Var {action {}}
  Var {centered 0}

  Method Close {} {
    grab release .rgb
    wm withdraw .rgb
    update idletasks
  }
  Method Cancel {} {
    Vars action original
    Self Close
    if {$action != ""} {
      set cmd [concat $action [list $original]]
      set action {}
      uplevel \#0 $cmd
    }
  }

  Method OK {} {
    Vars action color
    Self ColorFromEntry
    Self Close
    if {$action != ""} {
      set cmd [concat $action [list $color]]
      set action {}
      uplevel \#0 $cmd
    }
  }

  Method Request {color action {cancel none}} {
    set [var action] $action
    if {$cancel == "none"} {set [var original] $color} \
	else {set [var original] $cancel}
    if {$color == ""} {set color {0 0 0}}
    set [var color] $color
    Self ColorFromEntry
    Self Center
    if [winfo ismapped .rgb] {wm iconify .rgb}
    wm deiconify .rgb
    focus .rgb.entry
    if {[grab current .] != ""} {grab release [grab current .]}
    grab set .rgb
  }

  Method SetRGB {i v} {
    Vars color
    set c [lreplace $color $i $i $v]
    set color \
      [format "%.3g %.3g %.3g" [lindex $c 0] [lindex $c 1] [lindex $c 2]]
    Self SetColor
  }

  Method ColorFromEntry {} {
    Vars color
    if {[catch {
      .rgb.r set [lindex $color 0]
      .rgb.g set [lindex $color 1]
      .rgb.b set [lindex $color 2]
    }]} {Error "Color must be three decimal numbers"}
    Self SetColor
  }

  Method SetColor {} {
    Vars color
    set R [expr {int([.rgb.r get]*255)}]
    set G [expr {int([.rgb.g get]*255)}]
    set B [expr {int([.rgb.b get]*255)}]
    .rgb.color.box configure -background [format "\#%02X%02X%02X" $R $G $B]
  }

  Method Center {} {
    Vars centered
    if {!$centered} {
      set x [expr [winfo screenwidth .rgb]/2 - [winfo reqwidth .rgb]/2 - \
		  [winfo vrootx [winfo parent .rgb]]]
      set y [expr [winfo screenheight .rgb]/3 - [winfo reqheight .rgb]/2 -\
		  [winfo vrooty [winfo parent .rgb]]]
      wm geom .rgb +$x+$y
      set centered 1
    }
  }
}

toplevel .rgb
wm withdraw .rgb
wm title .rgb "$_program(id): RGB Requester"
wm minsize .rgb 100 70
wm resizable .rgb 1 0

frame .rgb.frame
frame .rgb.color; frame .rgb.color.box
frame .rgb.frameR; frame .rgb.frameG; frame .rgb.frameB
pack .rgb.color -in .rgb.frame -side right -fill y -pady 3 -padx 2
pack .rgb.color.box -expand 1 -fill both
pack .rgb.frameR .rgb.frameG .rgb.frameB -in .rgb.frame -side top -fill x

label .rgb.labelR -text "R: "
scale .rgb.r -showvalue 0 -from 0.0 -to 1.0 -orient horizontal \
  -command {_SelectRGB SetRGB 0} -activebackground red -resolution .001
pack .rgb.labelR -side left -in .rgb.frameR
pack .rgb.r -side left -in .rgb.frameR -expand 1 -fill x

label .rgb.labelG -text "G: "
scale .rgb.g -showvalue 0 -from 0.0 -to 1.0 -orient horizontal \
  -command {_SelectRGB SetRGB 1} -activebackground green -resolution .001
pack .rgb.labelG -side left -in .rgb.frameG
pack .rgb.g -side left -in .rgb.frameG -expand 1 -fill x

label .rgb.labelB -text "B: "
scale .rgb.b -showvalue 0 -from 0.0 -to 1.0 -orient horizontal \
  -command {_SelectRGB SetRGB 2} -activebackground blue -resolution .001
pack .rgb.labelB -side left -in .rgb.frameB
pack .rgb.b -side left -in .rgb.frameB -expand 1 -fill x

entry .rgb.entry -width 17 -textvariable [_SelectRGB var color] -justify center

button .rgb.ok -text "OK" -command {_SelectRGB OK} -underline 0
button .rgb.cancel -text "Cancel" -command {_SelectRGB Cancel} -underline 0

pack .rgb.frame -side top -expand 1 -fill both -padx 10 -pady 7
frame .rgb.pad -height 7; pack .rgb.pad -side bottom
pack .rgb.cancel -side left -padx 10 -pady 0
pack .rgb.ok -side right -padx 10 -pady 0
pack .rgb.entry -side left -ipady 3 -expand 1 -fill x

bind .rgb <Return>   {_button(Invoke) .rgb.ok}
bind .rgb <KP_Enter> {_button(Invoke) .rgb.ok}
bind .rgb <Alt-o>    {_button(Invoke) .rgb.ok}
bind .rgb <Alt-c>    {_button(Invoke) .rgb.cancel}
bind .rgb <Escape>   {_button(Invoke) .rgb.cancel}

bind .rgb.entry <Return> {_SelectRGB ColorFromEntry; break}
