set _require(driver) [lindex $argv 0]
set argv [lrange $argv 1 end]

set _require(dir) [file dir $argv0]
if {$_require(dir) == ""} {set _require(dir) .}
regsub {/module/[^/]*} $_require(dir) {} _require(root)
if {$_require(root) == ""} {set _require(root) .}

set _require(path) \
    [list \
      "." \
       $_require(dir) \
      "$_require(root)/driver/$_require(driver)" \
      "$_require(root)/lib" \
       $_require(root) \
     ]

proc _require(Find) {file} {
  global _require

  set filename $file
  if {! [regexp {^[\./]} $file ]} {
    foreach lib $_require(path) {
      set file "$lib/$filename"
      if [file exists $file] {return $file}
    }
    return ""
  } else {
    if ![file exists $file] {set file ""}
    return $file
  }
}

proc _require(Load) {name file} {
  global _require
  global errorCode errorInfo

  set code [uplevel \#0 "catch {source $file} _require($file-message)"]
  set message $_require($file-message)
  unset _require($file-message)
  if {$code == 0} {set _require(Loaded:$name) 1}
  return -code $code -errorcode $errorCode -errorinfo $errorInfo $message
}

proc Require {file} {
  global _require

  set filename [_require(Find) $file]
  if {$filename == ""} \
      {return -code error "Can't find required file '$file'"}
  if {! [info exists _require(Loaded:$file)]} {
    _require(Load) $file $filename
    set filename [_require(Find) config/$file]
    if {$filename != ""} {_require(Load) patch/$file $filename}
  }
}


