Require button.tcl
Require option.tcl

_option(Add) percent.percent.length 300

ooRoot Instance _SelectPercent {
  Var {action {}}
  Var {centered 0}
  Var original

  Method Close {} {
    grab release .percent
    wm withdraw .percent
    update idletasks
  }
  Method Cancel {} {
    Vars action original
    Self Close
    if {$action != ""} {
      set cmd [concat $action $original]
      set action {}
      uplevel \#0 $cmd
    }
  }

  Method OK {} {
    Vars action
    Self Close
    if {$action != ""} {
      set cmd [concat $action [.percent.percent get]]
      set action {}
      uplevel \#0 $cmd
    }
  }

  Method Request {title value action} {
    set [var action] $action
    set [var original] $value
    .percent.percent configure -label "$title:"
    .percent.percent set $value
    Self Center
    if [winfo ismapped .percent] {wm iconify .percent}
    wm deiconify .percent
    focus .percent
    if {[grab current .] != ""} {grab release [grab current .]}
    grab set .percent
  }

  Method Center {} {
    Vars centered
    if {!$centered} {
      set x [expr [winfo screenwidth .percent]/2 - \
                  [winfo reqwidth .percent]/2- \
		  [winfo vrootx [winfo parent .percent]]]
      set y [expr [winfo screenheight .percent]/3 - \
                  [winfo reqheight .percent]/2 - \
		  [winfo vrooty [winfo parent .percent]]]
      wm geom .percent +$x+$y
      set centered 1
    }
  }
}

toplevel .percent
wm withdraw .percent
wm title .percent "$_program(id): Percentage Requester"
wm minsize .percent 100 70
wm resizable .percent 1 0

scale .percent.percent -showvalue 1 -from 0 -to 100 -orient horizontal
button .percent.ok -text "OK" -command {_SelectPercent OK} -underline 0
button .percent.cancel -text "Cancel" \
 -command {_SelectPercent Cancel} -underline 0

pack .percent.percent -side top -fill x -padx 10
pack .percent.cancel -side left -padx 10 -pady 7
pack .percent.ok -side right -padx 10 -pady 7

bind .percent <Return>   {_button(Invoke) .percent.ok}
bind .percent <KP_Enter> {_button(Invoke) .percent.ok}
bind .percent <Alt-o>    {_button(Invoke) .percent.ok}
bind .percent <Alt-c>    {_button(Invoke) .percent.cancel}
bind .percent <Escape>   {_button(Invoke) .percent.cancel}
