proc -oo(VarName) {class var} {return $class.$var}
proc -oo(Private) {class name} {return -ooPrivate($class.$name)}
proc -oo(MethodName) {class method} {return $class:$method}
proc -oo(PartName) {class name} {return $class:$name}
proc -oo(OwnerName) {name} {regsub {(^|:)[^:]*$} $name {} name; return $name}

proc -oo(VarFind) {class var} {
  global -ooVar -ooPrivate
  if ![regexp {([^\(]*)(\(.*\))?$} $var junk basename itemname] \
      {set basename $var}
  set name [-oo(VarName) $class $basename]
  set object $class; set id $name
  while {$class != ""} {
    if [info exists -ooVar($name)] {
	set name [set -ooVar($name)]
	set -ooVar($id) $name
        if {[uplevel info vars $name] == ""} {uplevel 2 upvar \#0 $name $name}
	return "$name$itemname"
    }
    if [uplevel \#0 info exists $name] {
      set -ooVar($id) $name
      if {[uplevel info vars $name] == ""} {uplevel 2 upvar \#0 $name $name}
      return [-oo(VarName) $class $var]
    }
    set parent [-oo(Private) $class parent]
    if ![info exists $parent] {return ""}
    set class [set $parent]
    set name [-oo(VarName) $class $basename]
  }
}

proc -oo(MethodFind) {class method {error false}} {
  global -oo -ooMethod -ooPrivate
  set name [-oo(MethodName) $class $method]
  set object $class; set id $name
  while {$class != ""} {
  if [info exists -ooMethod($name)] {
    set -ooMethod($id) [set name [set -ooMethod($name)]]
    set -oo(class) [lindex $name 0]
    return [lindex $name 1]
  }
    if {[info procs $name] != ""} {
      set -oo(class) $class;
      set -ooMethod([-oo(MethodName) $object $method]) [list $class $name]
       return $name
    }
    set parent [-oo(Private) $class parent]
    if ![info exists $parent] {return ""}
    set class [set $parent]
    set name [-oo(MethodName) $class $method]
  }
}

proc -oo(RemoveError) {} {
  global errorInfo
  set errorInfo [split $errorInfo \n]
  while {![regexp {    (while executing|invoked from within)} \
	      [lindex $errorInfo end]]} \
      {set errorInfo [lreplace $errorInfo end end]}
  set errorInfo [join [lreplace $errorInfo end end] \n]
}

proc -oo(DoMethod) {context object method args} {
  global -oo errorCode errorInfo
  set proc [-oo(MethodFind) $object $method]
  if {$proc == ""} {
   return -code error -errorcode OO_BADMETHOD \
	"No method '$method' for object '$object'"
  }
  set oldcontext [set -oo(context)]
  set oldobject [set -oo(object)]
  set oldbase [set -oo(base)]
  set -oo(context) $context
  set -oo(object) [set -oo(class)]
  set -oo(base) $object
  if [set code [uplevel [list catch "$proc $args" -oo(err)]]] -oo(RemoveError)
  set -oo(context) $oldcontext
  set -oo(object) $oldobject
  set -oo(base) $oldbase
  return -code $code -errorcode $errorCode -errorinfo $errorInfo \
    [uplevel set -oo(err)]
}


proc Self {{method ""} args} {
  global -oo errorCode errorInfo
  set object [set -oo(context)]
  if {$method == ""} {return $object}
  set proc [-oo(MethodFind) $object $method]
  if {$proc == ""} {
    return -code error -errorcode OO_BADMETHOD \
	"No method '$method' for object '$object'"
  }
  set oldobject [set -oo(object)]
  set -oo(object) [set -oo(class)]
  if [set code [uplevel [list catch "$proc $args" -oo(err)]]] -oo(RemoveError)
  set -oo(object) $oldobject
  return -code $code -errorcode $errorCode -errorinfo $errorInfo \
    [uplevel set -oo(err)]
}

proc Parent {{method ""} args} {
  global -oo -ooPrivate errorCode errorInfo
  set parent [-oo(Private) [set -oo(object)] parent]
  if ![info exists $parent] {
    return -code error -errorcode OO_NOPARENT \
	"Object '[set -oo(object)]' has no parent"
  }
  set parent [set $parent]
  if {$method == ""} {return $parent}
  set context [set -oo(context)]
  if [set code [uplevel [list catch \
     "-oo(DoMethod) {$context} {$parent} {$method} $args" -oo(err)]]] \
      -oo(RemoveError)
  return -code $code -errorcode $errorCode -errorinfo $errorInfo \
    [uplevel set -oo(err)]
}

proc ParentMethod {{method ""} args} {
  global -oo -ooPrivate errorCode errorInfo
  set parent [-oo(Private) [set -oo(base)] parent]
  if ![info exists $parent] {
    return -code error -errorcode OO_NOPARENT \
	"Object '[set -oo(base)]' has no parent"
  }
  set parent [set $parent]
  if {$method == ""} {return $parent}
  set context [set -oo(context)]
  if [set code [uplevel [list catch \
     "-oo(DoMethod) {$context} {$parent} {$method} $args" -oo(err)]]] \
      -oo(RemoveError)
  return -code $code -errorcode $errorCode -errorinfo $errorInfo \
    [uplevel set -oo(err)]
}

proc Owner {{method ""} args} {
  global -oo errorCode errorInfo
  set owner [-oo(OwnerName) [set -oo(context)]]
  if {$owner == ""} {
    return -code error -errorcode OO_NOOWNER \
	"Object '[set -oo(context)]' has no owner"
  }
  if {$method == ""} {return $owner}
  if [set code [uplevel [list catch \
     "-oo(DoMethod) {$owner} {$owner} {$method} $args" -oo(err)]]] \
      -oo(RemoveError)
  return -code $code -errorcode $errorCode -errorinfo $errorInfo \
    [uplevel set -oo(err)]
}

proc OwnerMethod {{method ""} args} {
  global -oo errorCode errorInfo
  set owner [-oo(OwnerName) [set -oo(base)]]
  if {$owner == ""} {
    return -code error -errorcode OO_NOOWNER \
	"Object '[set -oo(base)]' has no owner"
  }
  if {$method == ""} {return $owner}
  if [set code [uplevel [list catch \
     "-oo(DoMethod) {$owner} {$owner} {$method} $args" -oo(err)]]] \
      -oo(RemoveError)
  return -code $code -errorcode $errorCode -errorinfo $errorInfo \
    [uplevel set -oo(err)]
}

proc var {var} {
  global -oo
  set name [-oo(VarFind) [set -oo(context)] $var]
  if {$name == ""} {
    regsub {\(.*\)$} $var {} var
    return -code error -errorcode OO_NOVAR \
	"Object '[set -oo(context)]' does not have a variable '$var'"
  }
  return $name
}

proc val {var} {
  global -oo
  set name [-oo(VarFind) [set -oo(context)] $var]
  if {$name == ""} {
    regsub {\(.*\)$} $var {} var
    return -code error -errorcode OO_NOVAR \
	"Object '[set -oo(context)]' does not have a variable '$var'"
  }
  return [uplevel \#0 set $name]
}

proc Vars {args} {
  foreach var $args {catch {uplevel upvar \#0 [var $var] $var}}
  return {}
}


proc Method {name args body} {
  global -oo
  set name [-oo(MethodName) [set -oo(name)] $name]
  proc $name $args $body
}

proc Var {var args} {
  global -oo -ooPrivate
  set name [set -oo(name)]
  foreach def [concat [list $var] $args] {
    if {[llength $def] > 2 || [llength $def] == 0} {
      return -code error -errorcode OO_BAD_VARDEF \
	  "Wrong number of elements in varaible definition '$def'"
    }
    if {[llength $def] == 1} {lappend def {}}
    if [info exists [-oo(Private) $name instance]] {
      uplevel \#0 [list set [-oo(VarName) $name [lindex $def 0]] \
		       [lindex $def 1]]
    } else {
      lappend [-oo(Private) $name vars] $def
    }
  }
}

proc ClassVar {var args} {
  global -oo
  foreach def [concat [list $var] $args] {
    if {[llength $def] > 2 || [llength $def] == 0} {
      return -code error -errorcode OO_BADCLASSVARDEF \
	  "Wrong number of elements in class variable definition '$def'"
    }
    if {[llength $def] == 1} {lappend def {}}
    set def [lreplace $def 0 0 [-oo(VarName) [set -oo(name)] [lindex $def 0]]]
    uplevel \#0 set $def
    if [regexp {\(\)$} [lindex $def 0]] \
	{uplevel \#0 unset [lindex $def 0]}
  }
}

proc _Part {args} {
  global -oo -ooPrivate
  set name [set -oo(name)]
  lappend [-oo(Private) $name parts] $args
}

proc -oo(Args) {name} {
  set args {}
  foreach arg [info args $name] {
    if {[info default $name $arg value]} {lappend arg $value}
    lappend args $arg
  }
  return $args
}


set -oo(root) "ooRoot"
set -oo(call) {
  global errorCode errorInfo
  if [set code [uplevel [list catch \
     "[list -oo(DoMethod) %N %N $method] $args" -oo(err)]]] -oo(RemoveError)
  return -code $code -errorcode $errorCode -errorinfo $errorInfo \
      [uplevel set -oo(err)]
}
set -oo(context) [set -oo(root)]
set -oo(object)  [set -oo(root)]
set -oo(base) ""

proc [-oo(MethodName) ooRoot Subclass] {name {def {}}} {
  global -oo -ooPrivate errorCode errorInfo

  set parent [set -oo(context)]
  if [info exists [-oo(Private) $parent instance]] {
    return -code error -errorcode OO_NOTCLASS "'$parent' is not a class object"
  }
  if {$name == ""} {
    return -code error -errorcode OO_BADCLASSNAME "Invalid class name '$name'"
  }
  if {[info procs $name] != ""} {
    puts stderr "Warning:  object '$name' being redefined"
    catch {$name Destroy}
  }
  regsub -all {%N} [set -oo(call)] $name call
  proc $name {method args} $call
  if {$name != [set -oo(root)]} \
    {set [-oo(Private) $name parent] [set -oo(context)]}

  set -oo(name) $name; set item {}
  set vars [-oo(Private) $parent vars]
  set vars [if [info exists $vars] {set $vars}]
  set [-oo(Private) $name vars] $vars
  set parts [-oo(Private) $parent parts]
  set parts [if [info exists $parts] {set $parts}]
  set [-oo(Private) $name parts] $parts

  foreach line [split $def \n] {
    set trimline [string trim $line]
    if {$trimline == "" || [string index $trimline 0] == "\#"} continue
    if {$item == ""} {set item $line} else {append item \n $line}
    if {[info complete $item] && [string trim $item] != ""} {
      switch -- [lindex $item 0] {
	Method - Var - ClassVar {}
	default {
	  switch -- [lindex $item 1] {
	    Instance {
	      set item [linsert $item 0 _Part]
	    }
	    ClassInstance {
	      set item [lreplace $item 1 2 \
			    Instance [-oo(PartName) $name [lindex $item 2]]]
	    }
	    default {
	      return -code error -errorcode OO_BADDEF \
		  [join [list "Unknown action '[lindex $item 0]'" \
			     "    while executing" \
			     "\"$item\""] \n]
	    }
	  }
	}
      }
      if [set code [uplevel [list catch $item -oo(err)]]] {
	return -code error -errorcode $errorCode -errorinfo $errorInfo \
	    [set -oo(err)]
      }
      set item {}
    }
  }
  unset -oo(name)
  if {$item != ""} {
    return -code error -errorcode OO_INCOMPLETEDEF \
	"Incomplete item in definition of object '$name'"
  }
}

proc [-oo(MethodName) ooRoot Instance] {name {def {}}} {
  global -oo -ooPrivate errorCode errorInfo

  set parent [set -oo(context)]
  if [info exists [-oo(Private) $parent instance]] {
    return -code error -errorcode OO_NOTCLASS "'$parent' is not a class object"
  }
  if {$name == ""} {
    return -code error -errorcode OO_BADOBJNAME "Invalid object name '$name'"
  }
  if {[info procs $name] != ""} {
    puts stderr "Warning:  object '$name' being redefined"
    catch {$name Destroy}
  }
  regsub -all {%N} [set -oo(call)] $name call
  proc $name {method args} $call
  set [-oo(Private) $name parent] [set -oo(context)]
  set [-oo(Private) $name instance] 1

  foreach var [set [-oo(Private) $parent vars]] {
    set var [lreplace $var 0 0 [-oo(VarName) $name [lindex $var 0]]]
    uplevel \#0 set $var
    if [regexp {\(\)$} [lindex $var 0]] \
	{uplevel \#0 unset [lindex $var 0]}
  }

  set parts [set [-oo(Private) $parent parts]]
  set [-oo(Private) $name parts] $parts
  set def [join [list $def [join $parts \n]] \n]

  set -oo(name) $name
  set item {}
  foreach line [split $def \n] {
    set trimline [string trim $line]
    if {$trimline == "" || [string index $trimline 0] == "\#"} continue
    if {$item == ""} {set item $line} else {append item \n $line}
    if {[info complete $item] && [string trim $item] != ""} {
      switch -- [lindex $item 0] {
	Method - Var {}
	default {
	  if {[lindex $item 1] != "Instance"} {
	    return -code error -errorcode OO_BADDEF \
		[join [list "Unknown action '[lindex $item 0]'" \
			    "    while executing" \
			    "\"$item\""] \n]
	  }
	  set item [lreplace $item 2 2 [-oo(PartName) $name [lindex $item 2]]]
	}
      }
      if [set code [uplevel [list catch $item -oo(err)]]] {
	return -code error -errorcode $errorCode -errorinfo $errorInfo \
	    [set -oo(err)]
      }
      set item {}
    }
  }

  if {$item != ""} {
    return -code error -errorcode OO_INCOMPLETEDEF \
	"Incomplete item in definition of object '$name'"
  }
}

proc [-oo(MethodName) ooRoot Destroy] {} {
  global -oo -ooPrivate -ooMethod -ooVar
  set name [set -oo(context)]
  if {$name == [set -oo(root)]} return
  foreach object [set [-oo(Private) $name parts]] {
    set object [-oo(PartName) $name [lindex $object 2]]
    $object Destroy
  }
  set vars [info globals [-oo(VarName) $name *]]
  foreach var $vars {uplevel \#0 unset $var}
  set vars [array names -ooPrivate [-oo(VarName) $name *]]
  foreach var $vars {unset -ooPrivate($var)}
  set vars [array names -ooVar [-oo(VarName) $name *]]
  foreach var $vars {unset -ooVar($var)}
  set pattern [-oo(MethodName) $name *]
  foreach proc [info procs $pattern] {rename $proc {}}
  foreach proc [array names -ooMethod $pattern] {unset -ooMethod($proc)}
  rename $name {}
}

[-oo(MethodName) ooRoot Subclass] ooRoot {
  Method Parent [-oo(Args) ParentMethod] [info body ParentMethod]
  Method Owner  [-oo(Args) OwnerMethod]  [info body OwnerMethod]
  Method Do {script} {uplevel $script}
  Method set {var value} {uplevel \#0 [list set [var $var] $value]}
  Method get {var} {val $var}
  Method var {name} {var $name}
  Method method {name} {
    global -oo
    set method [-oo(MethodFind) [set -oo(context)] $name]
    if {$method == ""} {
      return -code error -errorcode OO_BADMETHOD \
	  "Object '[set -oo(context)]' has no method '$name'"
    }
    return $method
  }
  Method isInstance {} {
    global -oo -ooPrivate
    return [info exists [-oo(Private) [set -oo(context)] instance]]
  }
  Method setContext {name} {global -oo; set -oo(context) $name}
  Method baseContext {} {global -oo; set -oo(base)}
  Method realContext {} {global -oo; set -oo(object)}
  Method Print {args} {
    global -ooPrivate
    set name [Self setContext [Self baseContext]]
    if {[llength $args] > 0} {
      foreach var $args {
	set var [var $var]
	if [uplevel \#0 array exists $var] {
	  set list [lsort [uplevel \#0 array names $var]]
	  if {[llength $list] > 0} {
	    foreach item $list {
	      puts stderr \
		  "  ${var}($item) = '[uplevel \#0 set ${var}($item)]'"
	    }
	  } else {
	    puts stderr "  $var (empty array)"
	  }
	} else {
	  puts stderr "  $var = '[uplevel \#0 set $var]'"
	}
      }
    } else {
      puts stderr ""
      puts stderr "---- Structure of Object '$name' ----"
      puts stderr ""
      if ![Self isInstance] {
	set list [-oo(Private) $name vars]
	if [info exists $list] {
	  puts stderr "Instance Variables:"
	  foreach var [lsort [set $list]] {
	    set var [lindex $var 0]; set val [-oo(VarName) $name $var]
	    puts stderr "  $var"
	  }
	  puts stderr ""
	}
	set list [-oo(Private) $name parts]
	if [info exists $list] {
	  puts stderr "Parts:"
	  foreach part [lsort [set $list]] {
	    if {[llength $part] > 3} {set part [lreplace $part 3 end {...}]}
	    puts stderr "  $part"
	  }
	  puts stderr ""
	}
      }
      puts stderr "Variables:"
      foreach var [lsort [uplevel \#0 info vars [-oo(VarName) $name *]]] {
	if [regexp {/-[^-]*-$} $var] continue
	if [uplevel \#0 array exists $var] {
	  set list [lsort [uplevel \#0 array names $var]]
	  if {[llength $list] > 0} {
	    foreach item $list {
	      set val [uplevel \#0 set ${var}($item)]
	      puts stderr "  ${var}($item) = '$val'"
	    }
	  } else {
	    puts stderr "  $var (empty array)"
	  }
	} else {
	  puts stderr "  $var = '[uplevel \#0 set $var]'"
	}
      }
      puts stderr ""
      set len [expr [string length $name] + 1]
      puts stderr "Methods:"
      foreach proc [lsort [info procs [-oo(MethodName) $name *]]] {
	if ![regexp -- {:} [string range $proc $len end]] \
	    {puts stderr "  $proc {[info args $proc]}"}
      }
      puts stderr ""
    }
  }
}
