Require label.tcl
Require text.tcl
Require error.tcl
Require button.tcl

set _name(title) ""
set _name(action) {}
set _name(centered) 0
set _name(type) ""

toplevel .name
wm withdraw .name
wm title .name "$_program(id): Name Requester"
wm minsize .name 100 70
wm resizable .name 1 0

label .name.title -textvariable _name(title)
entry .name.name -width 30 -textvariable _name(name)
button .name.ok -text "OK" -command {_name(OK)} -underline 0
button .name.cancel -text "Cancel" -command {_name(Cancel)} -underline 0

pack .name.title -side top -pady 4
pack .name.name -side top -fill x -padx 10
pack .name.cancel -side left -padx 10 -pady 7
pack .name.ok -side right -padx 10 -pady 7


bind .name <Return>   {_button(Invoke) .name.ok}
bind .name <KP_Enter> {_button(Invoke) .name.ok}
bind .name <Alt-o>    {_button(Invoke) .name.ok}
bind .name <Alt-c>    {_button(Invoke) .name.cancel}
bind .name <Escape>   {_button(Invoke) .name.cancel}


proc _name(Close) {} {
  grab release .name
  wm withdraw .name
  update idletasks
}

proc _name(Cancel) {} {_name(Close)}

proc _name(OK) {} {
  global _name
  if {$_name(name) == ""} {Error "You must supply $_name(type)"}
  if {$_name(action) != ""} {
    set action $_name(action)
    set _name(action) {}
    uplevel \#0 $action
  }
  _name(Close)
}

proc _name(Request) {title name action {ext ""} {type "a name"} {id "Name"}} {
  global _name _program
  set _name(name)   $name
  set _name(action) $action
  set _name(title)  $title
  set _name(type)   $type
  wm title .name "$_program(id): $id Requester"
  if {$name != ""} {
    .name.name selection range 0 end
    .name.name icursor end
    if {$ext != "" && [file extension $name] == $ext} {
      set last [string length [file rootname $name]]
      .name.name selection range 0 $last
      .name.name icursor $last
    }
  }
  _name(Center)
  if [winfo ismapped .name] {wm iconify .name}
  wm deiconify .name
  focus .name.name
  if {[grab current .] != ""} {grab release [grab current .]}
  grab .name
}

proc _name(Center) {} {
  global _name
  if {! $_name(centered)} {
    set x [expr [winfo screenwidth .name]/2 - [winfo reqwidth .name]/2 - \
	        [winfo vrootx [winfo parent .name]]]
    set y [expr [winfo screenheight .name]/3 - [winfo reqheight .name]/2 - \
	        [winfo vrooty [winfo parent .name]]]
    wm geom .name +$x+$y
    set _name(centered) 1
  }
}