Require eval.tcl
Require option.tcl

_option(Add) menu(font)		"*-helvetica-bold-r-normal--*-140-*" 
_option(Add) menu(relief)	groove 
_option(Add) menu(bd)		3 
set _menu(font)    [option get . menu(font) *]
set _menu(relief)  [option get . menu(relief) *]
set _menu(bd)      [option get . menu(bd) *]

_option(Add) Menubutton.font	$_menu(font) 
_option(Add) Menubutton.padX	9 
_option(Add) Menu.font		$_menu(font) 

_option(Add) popup(relief)	groove 
_option(Add) popup(bd)		3 
set _popup(relief) [option get . popup(relief) *]
set _popup(bd)     [option get . popup(bd) *]

_option(Add) listbox(font)	"*-courier-medium-r-normal--*-180-*" 
set _listbox(font) [option get . listbox(font) *]

_option(Add) Listbox.font 	$_listbox(font) 
_option(Add) Listbox.selectBorderWidth 0 
_option(Add) Listbox.selectBackground white 

set _menu(position) end

proc _menu(Bar) {parent name menus} {
  global _menu
  if {$parent == "."} {set frame .$name} else {set frame $parent.$name}
  if {![winfo exists $frame] } {
    _option(Set) $frame relief $_menu(relief)
    _option(Set) $frame borderWidth $_menu(bd)
    frame $frame; pack $frame -side top -fill x
  }
  set _menu(position) end
  set i 0
  while {[llength $menus] > 0} {
    set placement left
    set name "m$i"
    set title [_menu(Pull) menus]
    if {$title == ">>"} {
      set placement right
      set title [_menu(Pull) menus]
    }
    set items [_menu(Pull) menus]
    if {[llength $items] == 1} {
      set name $items
      set items [_menu(Pull) menus]
    }
    _menu(Button) $frame $name $placement $title $items
    incr i
  }
  return $frame
}

proc _menu(Button) {parent name placement title items args} {
  set underline [_menu(Underline) title]
  set button "$parent.$name"
  if {![winfo exists $button]} {
    _Eval [list menubutton $parent.$name \
		-text $title -menu $parent.$name.menu] $underline $args
    pack $button -side $placement
  }
  set menu [_menu(Menu) $parent.$name menu $items]
  if {[option get $menu tearOff *] == 0} {
    bind $button <2> {tkTearOffMenu %W.menu}
  }
  return $button
}

proc _menu(Menu) {parent name items args} {
  global _menu
  set menu "$parent.$name"
  if {![winfo exists $menu]} {_Eval menu $parent.$name $args}
  foreach item $items {
    set type [_menu(Pull) item]
    if {[info procs _menu(_$type)] != ""} {
      _Eval _menu(_$type) $menu $item
      if {$_menu(position) != "end"} {incr _menu(position)}
    } else {return -code error "Unknown menu type '$type'"}
  }
  set _menu(position) end
  return $menu
}

proc _menu(Popup) {parent name var items {select ""} {w ""} args} {
  global _popup
  if {$parent == "."} {set menu $name} else {set menu $parent.$name}
  _option(Set) $menu relief $_popup(relief)
  _option(Set) $menu borderWidth $_popup(bd)
  _Eval [list _menu(optionMenu) $menu $var] $items
  if {$w != ""} {$menu configure -width $w}
  if {$select != ""} {uplevel \#0 [list set $var $select]}
  _Eval [list pack $menu -side left] $args
  return $menu
}

proc _menu(Scrollable) {parent name title w h {pad 2} {ipad 2}} {
  global _menu
  if {$parent == "."} {set menu .$name} else {set menu $parent.$name}
  set frame $menu\(box\)
  set label $menu\(title\)
  set scroll $menu\(scroll\)
  _option(Set) $menu width $w
  _option(Set) $menu height $h
  _option(Set) $frame relief groove
  _option(Set) $frame borderWidth 4
  _option(Set) $frame.inner relief sunken
  _option(Set) $frame.inner borderWidth 2
  frame $frame; frame $frame.inner
  scrollbar $scroll -command [list $menu yview]
  if {$title != ""} {
    _option(Set) $label font $_menu(font)
    _option(Set) $label relief flat
    label $label -text $title; pack $label -in $frame -side top -fill x
  }
  listbox $menu -relief flat -borderwidth 0\
      -yscrollcommand [list $scroll set] -exportselection false
  pack $frame -in $parent -side top -fill both -expand true -padx $pad
  pack $scroll -in $frame -side right -fill y
  pack $frame.inner -fill both -expand true -padx $ipad -pady $ipad
  pack $menu -in $frame.inner -side top -fill both -expand true
  return $menu
}


proc _menu(_Action) {menu title {cmd ""} {accel ""} args} {
  global _menu
  set underline [_menu(Underline) title]
  _Eval [list $menu insert $_menu(position) command -label $title \
                -command $cmd] $underline $args
  _menu(Accelerator) $menu $accel
}

proc _menu(_Line) {menu} {
  global _menu
  $menu insert $_menu(position) separator
}

proc _menu(_Check) {menu title var {cmd ""} {checked ""} {accel ""} args} {
  global _menu
  upvar \#0 $var v
  set underline [_menu(Underline) title]
  _Eval [list $menu insert $_menu(position) checkbutton -label $title \
            -command $cmd -variable $var] $underline $args
  _menu(Accelerator) $menu $accel
  if {$checked != ""} {set v 1; catch {uplevel \#0 $cmd}}
}

proc _menu(_Radio) {menu title var {val [none]} {cmd ""}
                      {checked ""} {accel ""} args} {
  global _menu
  upvar \#0 $var v
  if {$val == {[none]}} {set val $title}
  set underline [_menu(Underline) title]
  _Eval [list $menu insert $_menu(position) radiobutton -label $title \
            -command $cmd -variable $var -value $val] $underline $args
  _menu(Accelerator) $menu $accel
  if {$checked != ""} {set v $val; catch {uplevel \#0 $cmd}}
}

proc _menu(_Menu) {menu title name items {accel ""} args} {
  global _menu
  set underline [_menu(Underline) title]
  _Eval [list $menu insert $_menu(position) cascade -label $title \
         -menu [_menu(Menu) $menu $name $items -tearoff 0]] $underline $args
  _menu(Accelerator) $menu $accel
}


proc _menu(Pull) {var} {
  upvar $var list
  set item [lindex $list 0]
  set list [lrange $list 1 end]
  return $item
}

proc _menu(Underline) {var} {
  upvar $var name
  set i [string first _ $name]
  if {$i >= 0} {
    regsub _ $name {} name
    return "-underline $i"
  }
  return
}

proc _menu(Accelerator) {menu accel} {
  if {$accel != ""} {
    $menu entryconfigure end -accelerator "  ($accel)"
    if [regexp {^Alt-(.) ?(.)?$} $accel junk key1 key2] {
      set key1 [string tolower $key1]
      set key2 [string tolower $key2]
      bind all <Alt-Key-$key1>$key2 "$menu invoke [$menu index end]; break"
    }
  }
}


#
#  Make copy of tk_optionMenu that uses options database
#
auto_load tk_optionMenu
set _menu(script) [info body tk_optionMenu]
regsub -all {(-relief [^ ]+|-bd [0-9]+) *} $_menu(script) {} _menu(script)
regsub -all {(-pady [0-9]+[picm]) *} $_menu(script) {} _menu(script)
proc _menu(optionMenu) [info args tk_optionMenu] $_menu(script)
unset _menu(script)
