Require bind.tcl
Require vector.tcl

proc _driver(GetDimension) {} {return 3}
proc _driver(SetDimension) {d} {return $d}

set _action(driver) 1

set _axis(x) 1
set _axis(y) 2
set _axis(z) 3
set _axis(w) 4
set _axis(u) 3
set _axis(v) 4

set _axis(X) 1
set _axis(Y) 2
set _axis(Z) 3
set _axis(W) 4
set _axis(U) 3
set _axis(V) 4


proc _matrix(Begin) {} {
  global _matrix
  set _matrix(dim) ""
  _matrix(GetDimension)
}

proc _matrix(GetDimension) {} {
  global _action _matrix
  if {$_action(driver)} {set dim [_driver(GetDimension)]} else {set dim 3}
  if {$dim != $_matrix(dim)} {
    set _matrix(dim) $dim
    set _matrix(d+1) [expr $dim+1]
    _matrix(Identity)
  }
}

proc _matrix(Identity) {{dim ""}} {
  global _matrix
  if {$dim == ""} {set d [expr $_matrix(d+1)]} else {set d $dim}
  set I {}; set Z {}
  for {set i 0} {$i < $d} {incr i} {lappend Z 0}
  for {set i 0} {$i < $d} {incr i} {lappend I [lreplace $Z $i $i 1]}
  set I [join $I \n]
  if {$dim == ""} {set _matrix(I) $I; set _matrix(Z) $Z}
  return $I
}

proc _matrix(AddI) {M {c 1}} {
  global _matrix
  set d $_matrix(d+1)
  for {set i 0; set k 0} {$i < $d} {incr i; incr k $d; incr k} \
      {set M [lreplace $M $k $k [expr [lindex $M $k] + ($c)]]}
  return $M
}

proc Dimension {{n ""}} {
  global _matrix
  if {$n == ""} {return $_matrix(dim)}
  set _matrix(dim) [_driver(SetDimension) [uplevel "expr $n"]]
  set _matrix(d+1) [expr $_matrix(dim) + 1]
  _matrix(Identity)
  return $_matrix(dim)
}


proc _matrix(Offset) {M p} {
  if {$p != ""} {
    set T1 [uplevel 2 [list Translate $p]]
    set T2 [Translate [uplevel 2 [list - $p]]]
    set M [_matrix(Mult) $T1 [_matrix(Mult) $M $T2]]
  }
  return $M
}

proc _matrix(Column) {M j} {
  global _matrix
  if {$j > $_matrix(dim)} {return ""}
  set d $_matrix(d+1)
  for {set i 0; set k $j; set C ""} {$i < $d} {incr i; incr k $d} \
      {lappend C [lindex $M $k]}
  return $C
}

proc _matrix(Row) {M i} {
  global _matrix
  set d $_matrix(d+1)
  set i [expr $i*$d]; set j [expr $i + $_matrix(dim)]
  return [lrange $M $i $j]
}

proc _matrix(Origin) {M} {
  global _matrix
  return [lreplace [_matrix(Column) $M $_matrix(dim)] end end]
}

proc _matrix(E) {n} {
  global _matrix
  return [lreplace $_matrix(Z) $n $n 1]
}

proc _matrix(e) {n} {
  global _matrix
  return [lreplace [lreplace $_matrix(Z) end end] $n $n 1]
}


proc Scale {s args} {
  global _matrix
  if [catch {_bind(Rest) {{p ""}} {{amount= 1}} $args Scale} message] \
      {return -code error $message}

  if {$s == ""} {set s 1}
  while {[llength $s] < $_matrix(dim)} {lappend s [lindex $s 0]}

  for {set j 0; set k 0; set M $_matrix(I)} {$j < $_matrix(dim)} \
      {incr j; incr k $_matrix(dim); incr k 2} \
      {set M [lreplace $M $k $k \
		  [uplevel "expr (([lindex $s $j])-1) * ($amount) + 1"]]}
  return [_matrix(Offset) $M $p]
}

proc Translate {s args} {
  global _matrix
  if [catch {_bind(Rest) {{p ""}} {{amount= 1}} $args Translate} message] \
      {return -code error $message}

  for {set j 0; set S {}} {$j < [llength $s]} {incr j} \
      {lappend S [uplevel "expr ([lindex $s $j])*($amount)"]}
  set S [lreplace [concat $S $_matrix(Z)] $_matrix(dim) end 1]
  set d $_matrix(d+1)
  for {set i 0; set k 0; set M ""} {$i < $d} {incr i; incr k $d} {
    lappend M [concat [lrange $_matrix(I) $k [expr $k+$d-2]] [lindex $S $i]]
  }
  return [join $M \n]
}

proc AxisRotate {a b r args} {
  global _matrix _axis
  if [catch {_bind(Rest) {{p ""}} {{amount= 1}} $args AxisRotate} message] \
      {return -code error $message}

  if [info exists _axis($a)] {set a $_axis($a)}
  if [info exists _axis($b)] {set b $_axis($b)}
  incr a -1; incr b -1
  set r [uplevel "expr ($amount)*($r)"]
  set c [expr cos($r)]; set s [expr sin($r)]
  set M $_matrix(I)
  set j [expr $a*$_matrix(d+1) + $a]; set M [lreplace $M $j $j $c]
  set j [expr $a*$_matrix(d+1) + $b]; set M [lreplace $M $j $j [expr -($s)]]
  set j [expr $b*$_matrix(d+1) + $a]; set M [lreplace $M $j $j $s]
  set j [expr $b*$_matrix(d+1) + $b]; set M [lreplace $M $j $j $c]
  return [_matrix(Offset) $M $p]
}

proc XY {args} {uplevel AxisRotate X Y $args}
proc XZ {args} {uplevel AxisRotate X Z $args}
proc YZ {args} {uplevel AxisRotate Y Z $args}
proc XW {args} {uplevel AxisRotate X W $args}
proc YW {args} {uplevel AxisRotate Y W $args}
proc ZW {args} {uplevel AxisRotate Z W $args}

proc Matrix {M args} {
  if [catch {_bind(Rest) {{p ""}} {{amount= 1}} $args Matrix} message] \
      {return -code error $message}
  return [_matrix(Offset) $M $p]
}

proc Rotate {U V r args} {
  global _matrix _vector
  if [catch {_bind(Rest) {{p ""}} {{amount= 1}} $args Rotate} message] \
      {return -code error $message}
  set U [Unit $U]; set V [Unit $V]
  set m [Dot $U $V]
  if {$m != 0} {
    if {abs(abs($m)-1) < $_vector(epsilon)} {
      set V [concat [lindex $V end] [lreplace $V end end]]
      set m [Dot $U $V]
    }
    set V [Unit [- $V [* $m $U]]]
  }
  set R [_matrix(AddI) [uplevel [list AxisRotate X Y $r -amount $amount]] -1]
  set A [concat $U 0 $V 0]
  for {set j 1} {$j < $_matrix(dim)} {incr j} {append A " " $_matrix(Z)}
  set At [Transpose $A]
  set M [_matrix(AddI) [_matrix(Mult) $At [_matrix(Mult) $R $A]]]
  return [_matrix(Offset) $M $p]
}

proc Spin3D {U r args} {
  if [catch {_bind(Rest) {{p ""}} {{amount= 1}} $args Spin3D} message] \
      {return -code error $message}
  set U [Unit $U]
  if [=== $U {0 0 1}]  {return [uplevel [list XY $r $p -amount $amount]]}
  if [=== $U {0 0 -1}] {return [uplevel [list XY -($r) $p -amount $amount]]}
  set V [Unit [- {0 0 1} [* [lindex $U 2] $U]]]
  set W [>< $U $V]
  return [uplevel [list Rotate $V $W $r $p -amount $amount]]
}

proc Product {args} {
  global _matrix
  if [catch {_bind(Rest) {args} {{amount= 1}} $args Product} message] \
      {return -code error $message}
  if {[llength $args] == 0} \
      {return -code error "Missing transform for Product"}
  set M $_matrix(I)
  foreach T $args \
    {set M [_matrix(Mult) $M [uplevel [concat $T -amount $amount]]]}
  return $M
}

proc Between {M1 {M2 ""}} {
  global _matrix _vector; set T {}
  if {$M2 == ""} {set M $M1} else {
    set M [uplevel \
      [list _matrix(Mult) [uplevel [list _matrix(Inverse) $M2]] $M1]]
  }
  set t [_matrix(Origin) $M]
  if [!== $t [lreplace $_matrix(Z) end end]] {
    lappend T [list Translate $t]
    set M [_matrix(Mult) [Translate [- $t]] $M]
  }
  for {set i 0; set s ""; set S ""; set id 1} {$i < $_matrix(dim)} {incr i} {
    set x [Norm [_matrix(Apply) $M [_matrix(E) $i]]]
    lappend s $x; lappend S [expr 1/double($x)]
    if {abs($x-1) > $_vector(epsilon)} {set id 0}
  }
  if {!$id} {lappend T [list Scale $s]}
  set M [_matrix(Mult) [Scale $S] $M]

  set count 0
  while {[set R [_matrix(RotateTo) $M]] != {}} {
    lappend T $R
    set M [_matrix(Mult) [Transpose [eval $R]] $M]
    incr count
    if {$count > $_matrix(dim)} \
     {return -code error "Can't resolve matrix rotations"}
  }

  if {[llength $T] == 0} {set T {Scale 1}} \
      elseif {[llength $T] == 1} {set T [lindex $T 0]} \
      else {set T [concat Product $T]}
  return $T
}

proc To {M {object ""}} {
  global _matrix
  if {$object == ""} {set M1 ""} else {set M1 [_transform(Get) $object]}
  return [uplevel [list Between $M $M1]]
}

proc _matrix(RotateTo) {M} {
  global _matrix pi
  if {[=== $M $_matrix(I)]} {return {}}
  _matrix(FindE) $M e0 e1 i 0
  set e2 [_matrix(apply) $M $e1]
  set U [Unit [- $e1 $e0]]
  if [=== $e2 $e0] {
    _matrix(FindE) $M e1 e2 i $i+1
    set V [Unit [- $e2 $e1]]
    if [=== 1 [expr abs([Dot $U $V])]] {
      _matrix(FindE) $M e1 e2 i $i+1
      set V [Unit [- $e2 $e1]]
    }
  } else {
    set V [Unit [- $e2 $e1]]
  }
  set a [Dot $U [_matrix(apply) $M $U]]
  if {$a < -1} {set a -1} elseif {$a > 1} {set a 1}
  return [list Rotate $U $V [expr acos($a)]]
}

proc _matrix(FindE) {M U V I n} {
  global _matrix
  upvar $U u; upvar $V v; upvar $I i; set i [uplevel expr $n]
  while {$i < $_matrix(dim)} {
    set u [_matrix(e) $i]
    set v [_matrix(apply) $M $u]
    if [!== $u $v] return
    incr i
  }
  return $_matrix(Z)
}


#
#  Obsolete
#
proc _matrix(RotateND) {M T} {
  global _matrix _vector
  set d [expr $_matrix(dim)-1]
  for {set i 0} {$i < $d} {incr i} {
    set E [lreplace [_matrix(Column) $M $i] end end]
    set e [_matrix(e) $i]; set a [Dot $e $E]
    if {$a < -1} {set a -1} elseif {$a > 1} {set a 1}
    set a [expr acos($a)]
    if {abs($a) > $_vector(epsilon)} {
      lappend T [list Rotate $e $E $a]
      set M [_matrix(Mult) [Rotate $E $e $a] $M]
    }
  }
  return $T
}

#
#  Obsolete
#
proc _matrix(Rotate3D) {M T} {
  global _matrix pi
  set e0 {1 0 0}
  set e1 [_matrix(apply) $M $e0]
  if [=== $e1 $e0] {
    set e0 {0 1 0}
    set e1 [_matrix(apply) $M $e0]
    if [=== $e0 $e1] {return $T}
  }
  set e2 [_matrix(apply) $M $e1]
  if [=== $e2 $e0] {
    set N [+ $e0 $e1]
    if [=== $N {0 0 0}] {
      set e0 [concat [lindex $e0 end] [lreplace $e0 end end]]
      set e1 [_matrix(apply) $M $e0]
      set N [+ $e1 $e0]
      if [=== $N {0 0 0}] {
	set e0 [concat [lindex $e0 end] [lreplace $e0 end end]]
	set e1 [_matrix(apply) $M $e0]
	set N [+ $e1 $e0]
      }
    }
    lappend T [list Spin3D [Unit $N] $pi]
  } else {
    set U [Unit [- $e1 $e0]]
    set V [Unit [- $e2 $e1]]
    set N [Unit [>< $U $V]]
    set a [Dot $U [_matrix(apply) $M $U]]
    if {$a < -1} {set a -1} elseif {$a > 1} {set a 1}
    lappend T [list Spin3D $N [expr acos($a)]]
  }
  return $T
}



proc _matrix(Inverse) {M} {
  global _matrix
  set t [uplevel [list - [_matrix(Origin) $M]]]
  if [!== $t [lreplace $_matrix(Z) end end]] {
    set IM [Translate $t]
    set M [_matrix(Mult) $IM $M]
  } else {set IM $_matrix(I)}
  for {set i 0; set S ""; set id 1} {$i < $_matrix(dim)} {incr i} {
    set x [Norm [uplevel [list * $M [_matrix(E) $i]]]]
    lappend S [expr 1/double($x)]; if {$x != 1} {set id 0}
  }
  if {!$id} {
    set S [Scale $S]
    set IM [_matrix(Mult) $S $IM]
    set M [_matrix(Mult) $S $M]
  }
  return [_matrix(Mult) [Transpose $M] $IM]
}

proc _matrix(Print) {M {d ""}} {
  global _matrix
  if {$d == ""} {set d $_matrix(d+1)}
  Print "\["
  for {set i 0; set k 0} {$i < $d} {incr i; incr k $d} \
      {Print "  [lrange $M $k [expr $k+$d-1]]"}
  Print "\]"
}

proc _matrix(Mult) {A B} {
  global _matrix _action
  if {!$_action(driver)} {return $_matrix(I)}
  set d $_matrix(d+1)
  for {set i 0; set M ""} {$i < $d} {incr i; lappend M $R} {
    for {set j 0; set R ""} {$j < $d} {incr j; lappend R $m} {
      set m 0; set a [expr $i * $d]; set b $j;
      for {set k 0} {$k < $d} {incr k; incr a; incr b $d} \
	{set m [uplevel "expr $m + ([lindex $A $a])*([lindex $B $b])"]}
    }
  }
  return [join $M \n]
}

proc _matrix(Apply) {A x} {
  global _matrix
  set d $_matrix(d+1)
  for {set i 0; set k 0} {$i < $d} {incr i; lappend X $m} {
    for {set j 0; set m 0} {$j < $d } {incr j; incr k} \
	{set m [uplevel "expr $m + ([lindex $A $k])*([lindex $x $j])"]}
  }
  return $X
}

proc _matrix(apply) {A x} {
  return [lreplace [_matrix(Apply) $A [concat $x 1]] end end]
}
