Require eval.tcl
Require menu.tcl
Require option.tcl

_option(Add) label(font) "*-helvetica-bold-r-normal--*-140-*" 
_option(Add) label(padx) 0 
_option(Add) label(pady) 2 

set _label(font)   [option get . label(font) *]
set _label(padx)   [option get . label(padx) *]
set _label(pady)   [option get . label(pady) *]

_option(Add) Label.font $_label(font) 


proc _label(Entry) {parent name title var {w 10} {fargs {}} args} {
  global _label
  if {$parent == "."} {set entry .$name} else {set entry $parent.$name}
  set frame $entry\(frame\)
  set label $entry\(title\)
  frame $frame
  _Eval [list pack $frame -fill x \
	     -padx $_label(padx) -pady $_label(pady)] $fargs
  if {$var != ""} {set var "-textvariable $var"}
  _Eval [list entry $entry -width $w] $var $args
  label $label -text "$title " -anchor e
  pack $entry $label -in $frame -side right
  return $entry
}

proc _label(Text) {parent name title {w 10} {h 3} args} {
  set text [_Eval [list _text(Scrollable) $parent $name $w $h] $args]
  set label $text\(title\)
  label $label -text "$title " -anchor e
  pack $label -in $text\(box\) -side left -before $text\(scroll\)
  return $text
}

proc _label(Label) {parent name text {var {}} args} {
  global _label
  if {$parent == "."} {set label .$name} else {set label $parent.$name}
  if {$var == ""} {_Eval [list label $label -text $text] $args} \
    else {_Eval [list label $label -textvar $var] $args}
  pack $label -padx $_label(padx) -pady $_label(pady)
  return $label
}

proc _label(Menu) {parent name title var items {select ""} {w {}} args} {
  global _label
  if {$parent == "."} {set menu .$name} else {set menu $parent.$name}
  set frame $menu\(frame\)
  set label $menu\(title\)
  frame $frame
  _Eval [list pack $frame -fill x \
	     -padx $_label(padx) -pady $_label(pady)] $args
  _Eval [list _menu(Popup) $parent $name $var $items $select $w] $args
  pack forget $menu
  label $label -text "$title "
  pack $menu $label -in $frame -side right
  return $menu
}
