proc _interpolate(_linear) {i n {e1 0} {e2 ""}} {
  if {$e2 == ""} {set e2 $e1}
  return [uplevel "expr ($i/double($n))*(1-($e1)-($e2)) + ($e1)"]
}

proc _interpolate(_arithmetic) {i n a b {e1 0} {e2 ""}} {
  set a  [uplevel "expr $a"]
  set b  [uplevel "expr $b"]
  set e1 [uplevel "expr $e1"]
  if {$e2 == ""} {set e2 $e1} else {set e2 [uplevel "expr $e2"]}
  return [expr ($i*($a+($i-1)*$b/2.)/($n*($a+($n-1)*$b/2.)))*(1-$e1-$e2)+$e1]
}

proc _interpolate(_geometric) {i n a {e1 0} {e2 ""}} {
  global _frame
  set e1 [uplevel "expr $e1"]
  if {$e2 == ""} {set e2 $e1} else {set e2 [uplevel "expr $e2"]}
  set a [uplevel "expr pow($a,1/double($_frame(resolution)))"]
  return [expr ((pow($a,$i)-1)/(pow($a,$n)-1))*(1-$e1-$e2) + $e1]
}

proc _interpolate(_natural) {i n {a 2} {e1 0} {e2 ""}} {
  set a  [uplevel "expr $a"]
  set e1 [uplevel "expr $e1"]
  if {$e2 == ""} {set e2 $e1} else {set e2 [uplevel "expr $e2"]}
  return [expr ((atan($a*(2*$i/double($n)-1))/atan($a)+1)/2)*(1-$e1-$e2)+$e1]
}

proc _interpolate(Select) {cmd i n} {
  set name [lindex $cmd 0]
  set cmd [linsert $cmd 1 $i $n]
  if {[info procs _interpolate(_$name)] != ""} \
      {set cmd [lreplace $cmd 0 0 _interpolate(_$name)]}
  uplevel 2 $cmd
}
