Require bind.tcl

proc _driver(Print) {lines} {}

set _input(queue)   0
set _input(buffer)  0
set _input(block)   0
set _input(eof)     0

set _command(queue)   0
set _command(buffer)  0
set _command(pattern) {^<< Command: +(.+) +>>$}
set _command(module)  ""
set _command(hub)     "StageDoor"

set _reply(queue)   0
set _reply(count)   0
set _reply(pattern) {^<< Reply: +(.+) +>>$}


if {[info procs Print] == ""} {
  proc Print {args} {foreach line $args {puts stderr $line}; flush stderr}
}

proc Input {v} {
  global _input
  upvar $v x

  set i $_input(queue); incr _input(queue)
  if {$i >= $_input(buffer)} {
    _input(StopHandler)
    while {$i >= $_input(buffer)} {_input(Handler)}
    _input(StartHandler)
  }

  set x $_input($i)
  unset _input($i)

  if {$_input(queue) == $_input(buffer)} {
    set _input(queue) 0
    set _input(buffer) 0
  }

  set len [string length $x]
  if {$_input(eof)} {set len -1}
  return $len
}

proc _input(StartHandler) {} {fileevent stdin read {_input(Handler)}}
proc _input(StopHandler) {} {fileevent stdin read {}}

proc _input(Handler) {} {
  global _input _command _reply _status

  if [set _input(eof) [expr [gets stdin line] == -1]] {
    puts stderr ">> EOF: command input terminated"
    _input(StopHandler)
  }
  if {[regexp $_command(pattern) $line x data] && 
      [_Bind {from id n} $data]} {
    set command [read stdin $n]; read stdin 1
    set _command($_command(buffer)) [list $from $id $command]
    incr _command(buffer)
    after idle {_command(Handler)}
  } elseif {[regexp $_reply(pattern) $line x data] &&
	    [_Bind {from id code ecode m n} $data]} {
    set message [read stdin $m]; read stdin 1
    set einfo   [read stdin $n]; read stdin 1
    set _reply($id) [list $code $message $ecode $einfo]
  } elseif {[info exists _status(pattern)] &&
	    [regexp $_status(pattern) $line x command] &&
	    [info procs _status(_$command)] != ""} {
    after 0 "_status(_$command)"
  } else {
    set _input($_input(buffer)) $line
    incr _input(buffer)
  }
}


proc _command(Handler) {} {
  global _input _command
  if {$_input(block)} return
  while {$_command(queue) < $_command(buffer)} {
    if {[info exists _command($_command(queue))]} {
      set command $_command($_command(queue))
      unset _command($_command(queue))
      eval _command(Invoke) $command
    }
    incr _command(queue)
  }
  set _command(buffer) 0
  set _command(queue) 0
}

proc _command(Invoke) {from id command} {
  global errorCode errorInfo _command
  set code [uplevel \#0 [list catch $command _command(message)]]
  if {$id != ""} {
    set msglen [string length $_command(message)]
    if {! $code} {set errorInfo ""}
    set errlen [string length $errorInfo]
    set data \
      [list $from $id $code $errorCode $msglen $errlen $_command(module)]
    _command(Print) "Reply $data" $_command(message) $errorInfo
  }
  unset _command(message)
}

proc _command(Send) {to command args} {
  global _reply _command
  if [catch {_bind(Flags) {{timeout= 60} {!confirm 0 1 1} {!reply 0 1 1}} \
		 $args _command(Send)} message] {return -code error $message}

  set i {{}}; if {$reply} {set i $_reply(count); incr _reply(count)}
  set n [string length $command]
  set options "-timeout $timeout";
  if {$confirm} {lappend options "-confirm"} \
      else {lappend options "-noconfirm"}
  _command(Print) "Send $to $i $n $_command(module) $options" $command
  if {!$reply} {return}
  tkwait variable _reply($i)
  set data $_reply($i)
  unset _reply($i)
  incr _reply(count) -1
  if {$_reply(count) == 0} {set _reply(queue) 0}
  return -code [lindex $data 0] -errorcode [lindex $data 2] \
      -errorinfo [lindex $data 3] [lindex $data 1]
}

proc _command(Register) {module emodule} {
  global _command
  set _command(module) $module
  _command(Print) [list Register $module $emodule]
}

proc _command(Print) {args} {
  global _command
  if {$_command(module) == ""} {foreach line $args {puts $line}} \
      else {_driver(Print) $args}
  flush stdout
}

proc _command(Sync) {} {_command(Print) "Sync"; Input sync}