Require commands.tcl
Require option.tcl

_option(Add) help(URL) "$_require(root)/doc/$_program(name)/welcome.html"

_option(Add) about.msg.font "*-courier-medium-r-normal--*-180-*" 
_option(Add) about.msg.wrapLength 6i 
_option(Add) about.msg.justify left 

_option(Add) help.msg.font "*-helvetica-medium-r-normal--*-180-*" 
_option(Add) help.msg.wrapLength 6i 

set _help(url)     [option get . help(URL) *]


#
#  Remove font specification from tk_dialog so we can 
#  supply our own (via option)
#
auto_load tk_dialog
set _help(dialog) [info body tk_dialog]
regsub "label \\\$w.msg \[^\n\]*" $_help(dialog) \
       {label $w.msg -text $text} _help(dialog)
proc _help(Dialog) [info args tk_dialog] $_help(dialog)
unset _help(dialog)


proc _help(About) {} {
  global _program
  _help(Dialog) .about "$_program(id): About" \
       [join [list \
 	     "Program:  $_program(id)" \
 	     "By:       Davide P. Cervone\n" \
 	     "From:     The Geometry Center" \
 	     "          400 Lind Hall" \
             "          207 CHurch Street S.E." \
 	     "          University of Minnesota" \
 	     "          Minneapolis, MN  55454\n" \
 	     "e-mail:   software@geom.umn.umn.edu" \
             "ftp:      annonymous@ftp.geom.umn.edu" \
 	     "www:      http://www.geom.umn.edu/"] \n] \
       {} 0 "Thanks!"
}

proc _help(Browser) {} {
  global _help _program
  set browser [_viewer(Web) $_help(url)]
  eval exec $browser &
  _help(Dialog) .help "$_program(id): Help" \
      "Launched \"[lindex $browser 0]\"" {} 0 "Thanks!"
}
