Require option.tcl

_option(Add) error.thanks.text "Thanks!" 
_option(Add) error.text.wrapLength 4i 
_option(Add) error.text.foreground red3 
_option(Add) error.text.font "*-helvetica-medium-o-normal--*-180-*" 

set _error(code) MYERROR
set _error(print) true

proc Error {message} {
  global _error
  return -code error -errorcode $_error(code) $message
}

proc _error(Thanks) {} {
  global _program
  grab release .error
  destroy .error
  if [info exists _program(grab)] {
    grab $_program(grab)
    unset _program(grab)
  }
}

catch {
  auto_load tkerror
  rename tkerror _error(tkerror)
}

proc tkerror {message} {
  global errorInfo errorCode _error
  if {$errorCode == $_error(code)} {
    if {$_error(print)} {puts stderr $message}
    _error(Message) $message
  } else {
    uplevel [list _error(tkerror) $message]
  }
}

proc _error(Message) {message} {
  global _program
  if [winfo exists .error] {destroy .error}
  toplevel .error -relief raised -bd 2
  wm title .error "$_program(id): Error!"
  frame .error.frame -relief sunken -bd 1; pack .error.frame -padx 3 -pady 3
  frame .error.frame.box -relief flat; pack .error.frame.box -padx 20 -pady 6
  label .error.text -text $message
  button .error.thanks -command {_error(Thanks)}
  pack .error.text .error.thanks -in .error.frame.box -side top -pady 3
  focus .error.thanks
  if {[grab current .] != ""} \
    {grab release [set _program(grab) [grab current .]]}
  grab .error
}