#
#  A special keymap for CTRL-K allows us to tell if the last thing pressed
#  was a CTRL-K (so that we add to the clipboard).
#
bind _ctrlK(map) <Any-KeyPress> {set _ctrlK(add) 0}
bind _ctrlK(map) <Any-1>        {set _ctrlK(add) 0}
bind _ctrlK(map) <Any-2>        {set _ctrlK(add) 0}
bind _ctrlK(map) <Any-3>        {set _ctrlK(add) 0}
bind _ctrlK(map) <Enter>        {set _ctrlK(add) 0}
bind _ctrlK(map) <Control-k> { }
bind _ctrlK(map) <Control-backslash> \
    {clipboard clear -displayof %W; set _ctrlK(add) 0}

set _ctrlK(add) 0

#
#  For a CTRL-K, clear the clipboard if this is the first one
#  Add the rest of the line to the clipboard and record that
#  we have been pressing CTRL-K.
#
#   CTRL-Y gets this data back.
#
proc _ctrlK(Text) {w} {
  global _ctrlK

  if {! $_ctrlK(add)} {clipboard clear -displayof $w}
  set text [$w get insert {insert lineend}]
  if {[$w compare insert == {insert lineend}]} {set text \n}
  catch {clipboard append -displayof $w -- $text}
  set _ctrlK(add) 1
}


proc _ctrlK(Bind) {w} {
  bindtags $w \
    [linsert [bindtags $w] [expr [llength [bindtags $w]] - 2] _ctrlK(map)]
  bind $w <Control-k> {_ctrlK(Text) %W}
}