Require option.tcl

_option(Add) confirm.msg.font "*-helvetica-medium-r-normal--*-180-*" 
_option(Add) confirm.msg.wrapLength 4i 

#
#  Remove font specification from tk_dialog so we can 
#  supply our own (via option)
#
auto_load tk_dialog
set _confirm(dialog) [info body tk_dialog]
regsub "label \\\$w.msg \[^\n\]*" $_confirm(dialog) \
       {label $w.msg -text $text} _confirm(dialog)
proc _confirm(Dialog) [info args tk_dialog] $_confirm(dialog)
unset _confirm(dialog)


proc Confirm {question {default 1}} {
  global _program
  set window [grab current .]
  set result [_confirm(Dialog) .confirm "$_program(id):  Confirmation" \
		  $question {} $default Yes No]
  update idletasks
  if {$window != ""} {grab set $window}
  return $result
}

proc ConfirmOK {message} {
  global _program
  set window [grab current .]
  _confirm(Dialog) .confirm "$_program(id):  Warning" $message {} 0 "Thanks!"
  if {$window != ""} {grab set $window}
  update idletasks
}