#
#  Add your _option(Default) statements here to override the default settings
#  Users can still use the .Xdefaults file to override these settings
#

Require option.tcl

#
#  This is a temporary hack until I redo the font defaults in a better
#  and more general way -- DPVC
#

#
#  Set font size and styles for general use
#
_option(Default) font(size)    14
_option(Default) font(big)     18
_option(Default) font(small)   12
_option(Default) font(label)   "helvetica-bold"
_option(Default) font(text)    "courier-medium"
_option(Default) font(info)    "helvetica-medium"

#
#  get settings (in case uer overrides using X-resources
#
set font(size)   [option get . font(size) *]
set font(big)    [option get . font(big) *]
set font(small)  [option get . font(small) *]
set font(label)  [option get . font(label) *]
set font(text)   [option get . font(text) *]
set font(info)   [option get . font(info) *]

#
#  create actual font names
#
set font(plain)  "*-$font(label)-r-normal--$font(size)-*"
set font(fixed)  "*-$font(text)-r-normal--$font(big)-*"
set font(list)   "*-$font(text)-r-normal--$font(size)-*"
set font(msg)    "*-$font(label)-r-normal--$font(big)-*"
set font(error)  "*-$font(label)-o-normal--$font(big)-*"
set font(info)   "*-$font(info)-r-normal--$font(small)-*"

#
#  set defaults for different classes of widgets (user can still override)
#
_option(Default) button(font)  $font(plain)
_option(Default) label(font)   $font(plain) 
_option(Default) menu(font)    $font(plain) 
_option(Default) listbox(font) $font(fixed)
_option(Default) text(font)    $font(fixed)
_option(Default) slider(font)  $font(plain)
_option(Default) message(font) $font(list)

#
#  set defaults for some dialog boxes
#
_option(Default) fname.button(font)   $font(plain)
_option(Default) fname.file(font)     $font(list)
_option(Default) fname.nonmatch(font) $font(list)
_option(Default) fname.dir(font)      $font(list)
_option(Default) confirm.msg.font     $font(msg)
_option(Default) error.text.font      $font(error)
_option(Default) about.msg.font       $font(fixed)
_option(Default) help.msg.font        $font(msg)
_option(Default) inform.Label.font    $font(plain)
_option(Default) message.font         $font(info)

#
# for StageHand (already does fontsize stuff)
#
_option(Default) fontsize     $font(size)