Require vector.tcl

set tcl_precision 17

set i {0 1}
set I {0 1}

set pi [expr atan(1)*4]

proc C* {X Y} {
  if {[llength $X] != 2 || [llength $Y] != 2} \
      {return -code error "C* only works for complex numbers"}
  set a [uplevel "expr [lindex $X 0]"]; set b [uplevel "expr [lindex $X 1]"]
  set c [uplevel "expr [lindex $Y 0]"]; set d [uplevel "expr [lindex $Y 1]"]
  return [list [expr $a*$c - $b*$d] [expr $a*$d + $b*$c]]
}

proc C/ {X Y} {
  if {[llength $X] != 2 || [llength $Y] != 2} \
      {return -code error "C/ only works for complex numbers"}
  set a [uplevel "expr [lindex $X 0]"]; set b [uplevel "expr [lindex $X 1]"]
  set c [uplevel "expr [lindex $Y 0]"]; set d [uplevel "expr [lindex $Y 1]"]
  if {$c == 0 && $d == 0} {return -code error "Division by zero"}
  set r [expr 1.0/($c*$c + $d*$d)];
  set c [expr $c * $r]; set d [expr -$d *$r ]
  return [list [expr $a*$c - $b*$d] [expr $a*$d + $b*$c]]
}

proc ^ {X Y} {
  if {[llength $X] == 2} {
    set n [uplevel "expr $Y"]
    set r [expr pow([uplevel [list Norm $X]],$n)]
    set t [expr $n*[uplevel [list Arg $X]]]
    return [list [expr $r*cos($t)] [expr $r*sin($t)]]
  } else {
    return [uplevel "expr pow($X,$Y)"]
  }
}

proc Exp {X} {
  if {[llength $X] == 2} {
    set r [uplevel "expr exp([lindex $X 0])"]
    set t [uplevel "expr [lindex $X 1]"]
    return [list [expr $r*cos($t)] [expr $r*sin($t)]]
  } else {
    return [uplevel "expr exp($X)"]
  }
}

proc Log {X} {
  if {[llength $X] == 2} {
    set r [uplevel [list Norm $X]]
    set t [uplevel [list Arg $X]]
    return [list [expr log($r)] $t]
  } else {
    return [uplevel "expr log($X)"]
  }
}

proc Sqrt {X} {return [uplevel [list ^ $X .5]]}

proc Sin {X} {
  if {[llength $X] == 2} {
    set a [uplevel "expr [lindex $X 0]"]; set b [uplevel "expr [lindex $X 1]"]
    return [list [expr  sin($a)*(exp(-($b)) + exp($b))/2] \
		 [expr -cos($a)*(exp(-($b)) - exp($b))/2]]
  } else {
    return [uplevel "expr sin($X)"]
  }
}

proc Cos {X} {
  if {[llength $X] == 2} {
    set a [uplevel "expr [lindex $X 0]"]; set b [uplevel "expr [lindex $X 1]"]
    return [list [expr cos($a)*(exp(-($b)) - exp($b))/2] \
		 [expr sin($a)*(exp(-($b)) + exp($b))/2]]
  } else {
    return [uplevel "expr cos($X)"]
  }
}

proc Conj {X} {return [list [uplevel "expr   [lindex $X 0]"] \
			    [uplevel "expr -([lindex $X 1])"]]}

proc Mod {X} {uplevel [list Norm $X]}

proc Arg {X} {
  if {[llength $X] != 2} \
      {return -code error "Arg only works for complex numbers"}
  set x [uplevel "expr [lindex $X 0]"]
  set y [uplevel "expr [lindex $X 1]"]
  if {$x == 0 && $y == 0} {return 0}
  return [uplevel "expr atan2($y,$x)"]
}

#proc Arg {X} {
#  global pi
#  if {[llength $X] != 2} \
#      {return -code error "Arg only works for complex numbers"}
#  set x [uplevel "expr [lindex $X 0]"]
#  set y [uplevel "expr [lindex $X 1]"]
#
#  if {$x == 0} {
#    if {$y == 0} {return 0}
#    return [if {$y < 0} {expr 3*$pi/2} {expr $pi/2}]
#  } else {
#    if {$x < 0} {return [expr atan($y/double($x))+$pi]}
#    if {$y < 0} {return [expr atan($y/double($x))+2*$pi]}
#    return [expr atan($y/double($x))]
#  }
#}

proc ArgMod {X} \
  {return [list [uplevel [list Arg $X]] [uplevel [list Norm $X]]]}
proc ModArg {X} \
  {return [list [uplevel [list Norm $X]] [uplevel [list Arg $X]]]}

proc Re {X} {return [uplevel "expr [lindex $X 0]"]}
proc Im {X} {return [uplevel "expr [lindex $X 1]"]}

