Require option.tcl

#
#  These options can be over-ridden by values in the .Xdefaults file
#

#  The different viewers
#
_option(Add) viewer(image)   "display %s" 
_option(Add) viewer(mpeg)    "mpeg_play -quiet %s" 
_option(Add) viewer(animGIF) "netscape -geometry 400x400 file:%s" 
_option(Add) viewer(web)     "netscape %s" 

#  How to make MPEG files
#
_option(Add) mpeg(encode)    "mpeg_encode -no_frame_summary %s 2>&1" 
_option(Add) mpeg(convert)   "convert * pnm:- 2>/dev/null" 

#  How to render .rib files
#
_option(Add) rib(render)     "render %s" 


#
#  The viewer for iamge files
#
proc _viewer(Image) {{name ""}} \
  {return [format [option get . viewer(image) *] $name]}

#
#  The viewer for MPEG files
#
proc _viewer(MPEG) {{name ""}} \
  {return [format [option get . viewer(mpeg) *] $name]}

#
#  The viewer for animated GIF files
#
proc _viewer(AnimGIF) {{name ""}} \
  {return [format [option get . viewer(animGIF) *] $name]}

#
#  The web browser
#
proc _viewer(Web) {{name ""}} \
  {return [format [option get . viewer(web) *] $name]}



#
#  The command for converting images from one type to another
#
proc _cmd(Convert) {old new type w h colors dither} {
  global _image
  set options "-geometry ${w}x${h} +comment"
  if {$colors != ""} {
    if {$dither} {append options " -dither"} else {append options " +dither"}
    append options " -colors $colors"
  }
  if {$type == "jpg"} {append options " -quality $_image(quality)"}
  return "convert $options $old $type:$new" 
}


#
#  The command for rendering .rib files
#
proc _cmd(RIB) {name} \
  {return [format [option get . rib(render) *] $name]}

#
#  The command for making MPEG movies
#
proc _cmd(mpegEncode) {name} \
  {return [format [option get . mpeg(encode) *] $name]}
#
#  The command to use in mpeg_encode's .param file for generating the
#  PPM files that it needs.
#
proc _cmd(mpegConvert) {} {return [option get . mpeg(convert) *]}


#
#  The command for creating an animated GIF
#
proc _cmd(gifMerge) {} {
  global _file _animGIF
  set options ""
  if {$_animGIF(loops) != ""} {
    if {[string tolower $_animGIF(loops)] == "forever"} {set _animGIF(loops) 0}
    append options " -l$_animGIF(loops)"
  }
  if {$_animGIF(delay) != ""} {append options " -$_animGIF(delay)"}
  if {$_animGIF(transparent) != ""} {
    regsub -all { } $_animGIF(transparent) {,} RGB
    regsub -all {,,+} $RGB {,} RGB
    append options " -$RGB"
  }
  set gifmerge "gifmerge $options $_animGIF(files)"
  return "(cd $_file(frameroot) && $gifmerge) 2>&1 > $_file(animGIF)"
}

