set Colors {
  {0 0 0}
  {1 0 0}
  {0 1 0}
}

proc MakeColorTable {n {circular 0}} {
  global Colors Color MaxColor
  set colors $Colors
  if {$circular} {lappend colors [lindex $colors 0]}
  set count [expr [llength $colors] - 1]
  lappend colors [lindex $colors end]
  for {set i 0} {$i <= $n} {incr i} {
    set r [expr $count*$i/double($n)]
    set j [expr int($r)]; set r [expr $r - $j]
    set m [lindex $colors $j]; set M [lindex $colors [expr $j+1]]
    set Color($i) [list \
		       [InterpolateColor $m $M 0 $r] \
		       [InterpolateColor $m $M 1 $r] \
		       [InterpolateColor $m $M 2 $r] \
		   ]
  }
  set MaxColor $n
}

proc InterpolateColor {m M i r} {
  set m [lindex $m $i]
  set M [lindex $M $i]
  return [expr $m + $r*($M - $m)]
}

proc GetColor {r} {
  global Color MaxColor
  return $Color([expr int($r*$MaxColor)])
}