Require eval.tcl
Require option.tcl

_option(Add) button(font)  "*-helvetica-bold-r-normal--*-140-*"
set _button(font)  [option get . button(font) *]

_option(Add) Button.font $_button(font) 

_option(Add) Checkbutton.font $_button(font) 
_option(Add) Checkbutton.highlightThickness 1 
_option(Add) Checkbutton.anchor w 
_option(Add) Checkbutton.padX 6 

_option(Add) Radiobutton.font $_button(font) 
_option(Add) Radiobutton.highlightThickness 1 
_option(Add) Radiobutton.anchor w 
_option(Add) Radiobutton.padX 6 


proc _button(Box) {parent name bplace buttons {fplace top} args} {
  if {$parent == "."} {set frame .$name} else {set frame $parent.$name}
  if {![winfo exists $frame]} {
    frame $frame; pack $frame -side $fplace -fill both
  }
  foreach button $buttons {
    _Eval [list _button(Button) $frame $bplace] $button $args
  }
  return $frame
}

proc _button(Button) {parent place type name title args} {
  if {[info procs _button(_$type)] != ""} {
    if {[regexp -nocase {^(left|right)$} $place]} \
	{set expand "-expand 1"} else {set expand ""}
    set underline [_button(Underline) title key]
    if {[string index $name 0] == "."} {set button $name} \
	else {set button $parent.$name}
    _Eval [list _button(_$type) $button $underline $title] $args
    _Eval pack $button -in $parent -fill x $expand -side $place
    if {$key != ""} {
      bind [winfo toplevel $button] <Alt-$key> "_button(Invoke) $button"
    }
  } else {
    return -code error "Unknown button type '$type'"
  }
}

set _button(invoke.groove) sunken
set _button(invoke.raised) sunken
set _button(invoke.ridge)  sunken
set _button(invoke.sunken) raised

proc _button(Invoke) {button} {
  global _button errorCode errorInfo
  set relief [$button cget -relief]
  if [info exists _button(invoke.$relief)] {
    $button configure -relief $_button(invoke.$relief)
    update idletasks
  }
  set code [catch [list uplevel \#0 "$button invoke"] message]
  set ecode $errorCode; set einfo $errorInfo
  $button configure -relief $relief
  return -code $code -errorcode $ecode -errorinfo $einfo $message
}

proc _button(_Action) {name underline title cmd args} {
  _Eval [list button $name -text $title -command $cmd] $args $underline
}

proc _button(_Check) {name underline title var {checked ""} {cmd ""} args} {
  upvar \#0 $var v
  _Eval [list checkbutton $name -text $title -command $cmd \
	     -variable $var] $underline $args
  if {$checked != ""} {set v 1; catch {uplevel \#0 $cmd}}
}

proc _button(_Radio) {name underline title var {value [none]} 
                          {checked ""} {cmd ""} args} {
  upvar \#0 $var v
  if {$value == {[none]}} {set value $title}
  _Eval [list radiobutton $name -text $title -command $cmd \
	     -variable $var -value $value] $underline $args
  if {$checked != ""} {set v $value; catch {uplevel \#0 $cmd}}
}

proc _button(Underline) {var key} {
  upvar $var name
  upvar $key k
  set k ""
  set i [string first _ $name]
  if {$i >= 0} {
    regsub _ $name {} name
    set k [string tolower [string index $name $i]]
    return "-underline $i"
  }
  return
}
