Require scale.tcl

if ![info exists _gv(Camera)] {set _gv(camera) "Camera"}


proc _driver(SizeWindow) {w h {x ""} {y ""}} {
  global _gv _image
  if {[_gv(EarlierV) 1.6] || $_image(shader) != "ppm"} {_image(_ScaleSize) w h}
  if {$x != "" && $y != ""} {
    if {[string index $x 0] != "-"} {incr x 0} else \
	{set x [expr [winfo screenwidth .] - $w + $x]}
    if {[string index $y 0] == "-"} {set y [expr -($y)]} else \
	{set y [expr [winfo screenheight .]- $h - $y]}
    incr w $x; incr h $y
    _gv(PlaceWindow) $w $h $x $y
  } else {
    _gv(SizeWindow) $w $h
  }
}

proc _gv(SizeWindow) {w h} {
  global _gv
  _command(TellGV) "(window $_gv(camera) {size $w $h})"
}

proc _gv(PlaceWindow) {w h x y} {
  global _gv
  _command(TellGV) "(window $_gv(camera) {position $x $w $y $h})"
}


proc _driver(GetWindowSize) {W H} {
  global _gv _image
  upvar $W w; upvar $H h
  _command(AskGV) "(write window - $_gv(camera))"
  Input line
  if ![regexp { size *([0-9]+) *([0-9]+)} $line size w h] {
    if ![regexp { position *[0-9]+ *([0-9]+) *[0-9]+ *([0-9]+)} \
          $line size w h] \
      {Error "Bad window size from Geomview: '$line'"}
  }
  if {[_gv(EarlierV) 1.6] || $_image(shader) != "ppm"} \
    {_image(_UnscaleSize) w h}
}

