if [info exists env(USER)] {set _gv(user) $env(USER)} else {set _gv(user) ""}
set _driver(tmpfile)   "/tmp/sm-$_gv(user)-[pid].ppm"
set _image(shader)     "ppm"
set _gv(version)       1.5

proc _driver(Snapshot) {image name type w h colors dither} {
  global _gv _image
  if {$type == "rib" || $_image(shader) == "rib"} {
    if ![regexp {.rib$} $name] {set name $name.rib}
    set snapshot "rib-snapshot $_gv(camera) $name"
  } else {
    if [_gv(EarlierV) 1.6] {
      set snapshot "snapshot $_gv(camera) $image"
    } else { 
      if {$type == "ps"} {set image $name} else {set type $_image(shader)}
      set snapshot "snapshot $_gv(camera) $image $type $w $h"
    }
  }
  _gv(Redraw)
  _command(AskGV) "($snapshot)(echo OK\\n)"
  Input OK
  _gv(Freeze)
}

proc _driver(Convert) {image name type w h colors dither {error ">&@stderr"}} {
  global _gv
  if {$type == "ps" || $type == "rib" || $image == ""} {return}
  if {$colors == "Millions"} {set colors ""}
  set cmd [_cmd(Convert) $image $name $type $w $h $colors $dither]
  if [regexp {[>&]} $cmd] {set cmd "/bin/sh -c \"($cmd)\""}
  eval exec $cmd >@stderr 2>@stderr
}

proc _gv(Version) {} {
  global _gv
  _command(AskGV) "(echo (geomview-version)\\n)";
  Input version
  set version [lindex $version 0]
  set vlist [lrange [split $version .] 0 1]
  set Mv [lindex $vlist 0]; set mv [lindex $vlist 1]
  regsub {[^0-9].*} $mv {} mv
  set _gv(version) "$Mv.$mv"
  set _gv(mesa) [regexp {MESA} $version]
  return $_gv(version)
}

proc _gv(EarlierV) {V} {
  global _gv
  set vv [split $V .]
  set vg [split $_gv(version) .]
  set Mv [lindex $vv 0]; set mv [lindex $vv 1]
  set Mg [lindex $vg 0]; set mg [lindex $vg 1]
  return [expr $Mg < $Mv || ($Mg == $Mv && $mg < $mv)]
}

proc _gv(NewShader) {} {
  global _image
  _driver(SizeWindow) $_image(w) $_image(h)
}


