Require transform.tcl
Require interpolate.tcl

lappend _script(frameChanged) \
  Transform Load Delete Appearance Camera Projection Background Geometry


proc _script(Count:Sequence) {name values} {
  global _script _frame
  set zero [expr {$_script(F:$name) != ""}]
  if [catch {_bind(Rest) {MM n {object ""}} \
       "!parent {!zero 1 0 $zero} {interp= linear}" \
       $values Sequence} err] {return -code error $err}
  set n [uplevel 2 "expr $n"]
  set n [expr int($n * $_frame(resolution))]
  if {$n < 1} {set n $zero}
  _script(Replace) $name [concat Sequence [lreplace $values 1 1 $n]]
  if {$zero == 0} {incr n}
  return $n
}

proc _script(Until:Sequence) {name values n} {
  global _script
  set zero [expr {$_script(F:$name) != ""}]
  if [catch {_bind(Rest) {MM {object ""}} \
       "!parent {!zero 1 0 $zero} {interp= linear}" \
       $values Sequence} err] {return -code error $err}
  if {$zero == 0} {incr n -1}
  return [concat Sequence [linsert $values 1 $n]]
}

proc _script(Action:Sequence) {name values} {
  global _script _transform
  set zero [expr {$_script(F:$name) != ""}]
  if [catch {_bind(Rest) {MM n {object ""}} \
       "!parent {!zero 1 0 $zero} {interp= linear}" \
       $values Sequence} err] {return -code error $err}
  if {$object == ""} {set object $_transform(default)}
  _script(HandleAction) $name {
    set i $zero
    if {$n < 1} {if {!$zero} {return -code return 1}}
    foreach obj $object {set _script(T:$name:$obj) [_transform(Get) $obj]}
  } {
    set M [uplevel 2 $MM -amount [_interpolate(Select) $interp $i $n]]
    foreach obj $object {
      if {$parent} \
	    {_transform(Set) [_matrix(Mult) $M $_script(T:$name:$obj)] $obj} \
       else {_transform(Set) [_matrix(Mult) $_script(T:$name:$obj) $M] $obj}
    }
  } {foreach obj $object {unset _script(T:$name:$obj)}}
  set _script(F:$name) 1
  return 0
}

