Require bind.tcl
Require eval.tcl
Require matrix.tcl
Require transform.tcl

proc _geometry(Begin) {movie} {
  global _geometry
  if {$movie} {catch {unset _geometry}}
}

proc Geometry {action args} {
  if {[info procs _geometry(_$action)] != ""} {
    if [catch {_Uplevel _geometry(_$action) $args} message] \
	{return -code error $message}
  } else {Error "Geomerty action \"$action\" not known"}
  return $message
}

proc _geometry(_build) {name def args} {
  global _geometry
  if [catch {_bind(All) {{appearance= {}} {transform= {}}} {} $args \
		 _geometry(_build)} message] {return -code error $message}
  if [regexp {/} $name] {Error "Object names can not include \"/\""}
  if {[llength [lindex $def 0]] == 1} {set def [list $def]}
  if {$transform != ""} {set T [uplevel $transform]}
  if {$appearance != ""} {set _geometry(A:$name) $appearance}
  uplevel [list _geometry(Build) $name $def]
  _geometry(_create) $name "{ : \"G:$name\"}"
  if {$transform != ""} {_transform(Set) $T $name}
  _frame(Changed)
}

proc _geometry(Build) {name def {new 1}} {
  global _geometry _matrix
  if {$new} {
    if [info exists _geometry(B:$name)] {_geometry(_delete) $name}
    set _geometry(B:$name) {}; set i 0
  } else {
    if ![info exists _geometry(B:$name)] \
	{Error "Compund object \"$name\" has not been built yet!"}
    set i [llength $_geometry(B:$name)]
  }
  foreach part $def {
    incr i; set pname $i; set named 0; set fullpart $part
    while {1} {
      set action [lindex $part 0]
      switch -- $action {
	= - : - < {
	  _geometry(Part) $name $pname $action [lrange $part 1 end] $fullpart
	  break
	}

	default {
	  if {[llength $action] > 1} {
	    _geometry(Part) $name $pname build $part $fullpart
	    break
	  } else {
	    if {$named} {
	      Error "Unknown Geometry type \"$action\" in {$part}"
	    } else {
	      set pname $action; set named 1
	      set part [lrange $part 1 end]
	      if [regexp {/} $pname] \
		  {Error "Part name \"$pname\" should not contain \"/\""}
	    }
	  }
	}
      }
    }
  }
  _geometry(Write) $name
}

proc _geometry(Part) {parent name action part full} {
  global _geometry _matrix
  _bind(Rest) {args} {{transform= {}} {appearance= {}}} $part "{$full}"
  if {$transform == ""} {set T $_matrix(I)} else {set T [uplevel 2 $transform]}
  _geometry(_transform) $parent/$name $T
  if {$appearance != ""} {set _geometry(A:$parent/$name) $appearance}
  lappend _geometry(B:$parent) $name
  switch $action {
    = {_geometry(_define) $parent/$name "{ = $args }"}
    : {_geometry(_define) $parent/$name ": \"G:$args\""}
    < {_geometry(_define) $parent/$name "< $args"}
    build {
      if {[llength $args] == 1} {set args [lindex $args 0]}
      uplevel 2 [list _geometry(Build) $parent/$name $args]
    }
    default {Error "Unknown action \"$action\"!"}
  }
}

proc _geometry(_add) {name def} {
  if {[llength [lindex $def 0]] == 1} {set def [list $def]}
  uplevel [list _geometry(Build) $name $def 0]
  _frame(Changed)
}

proc _geometry(_delete) {name args} {
  global _geometry
  foreach name [concat [list $name] $args] {
    set parent [file dirname $name]
    set pname [file tail $name]
    if {$parent == "."} {
      if ![info exists _geometry(B:$name)] {Delete $name}
    } else {
      set i 0
      foreach part $_geometry(B:$parent) {
	if {$part == $pname} {
	  set _geometry(B:$parent) [lreplace $_geometry(B:$parent) $i $i]
	  break
	}
	incr i
      }
    }
    _geometry(Delete) $name
  }
  _frame(Changed)
}

proc _geometry(Delete) {name} {
  global _geometry
  _geometry(_define) $name "{ = LIST }"
  catch {unset _geometry(T:$name)}
  if [info exists _geometry(B:$name)] {
    foreach part $_geometry(B:$name) {_geometry(Delete) $name/$part}
    unset _geometry(B:$name)
    catch {unset _geometry(A:$name)}
  }
  TellGV "(if (real-id $name) (delete $name))"
  _frame(Changed)
}

proc _geometry(_info) {name type} {
  global _geometry
  if ![_geometry(Exists) $name] \
      {Error "Compund object \"$name\" does not exist"}
  switch $type {
    children {
      if ![info exists _geometry(B:$name)] {return {}}
      return $_geometry(B:$name)
    }
    names {return [_geometry(InfoNames) $name]}
    structure {Error "Structure info not yet implemented"}
    default {Error "Unknown info type \"$type\""}
  }
}

proc _geometry(InfoNames) {name} {
  global _geometry
  if ![info exists _geometry(B:$name)] {return $name}
  set list $name
  foreach part $_geometry(B:$name) \
      {set list [concat $list [_geometry(InfoNames) $name/$part]]}
  return $list
}

proc _geometry(_create) {name oogl} {
  TellGV "(geometry \"$name\" {\n$oogl\n})"
  _frame(Changed)
}
proc _geometry(_define) {name oogl} {
  TellGV "(read geometry { define \"G:$name\"\n $oogl\n})"
  _frame(Changed)
}
proc _geometry(_change) {name def} {
  global _geometry
  if [info exists _geometry(B:$name)] \
      {Error "Object \"$name\" is a compund object"}
  if ![info exists _geometry(T:$name)] \
      {Error "Object \"$name\" does not exist"}
  _geometry(_define) $name $def
  _frame(Changed)
}

proc _geometry(_transform) {name {T ""}} {
  global _geometry _matrix
  if {$T == ""} {set T $_matrix(I)}
  set _geometry(T:$name) $T
  set T [Transpose $T]
  TellGV "(read transform { define $name {\n$T\n}})"
  _frame(Changed)
}

proc _geometry(_appearance) {name {appearance ""}} {
  global _geometry
  if {$appearance == ""} {
    if ![info exists _geometry(A:$name)] {return {}}
    return $_geometry(A:$name)
  }
  set _geometry(A:$name) $appearance
  if [info exists _geometry(B:$name)] {_geometry(Write) $name} \
      else {_geometry(Write) [file dirname $name]}
  _frame(Changed)
}

proc _geometry(_color) {name RGB} {
  uplevel [list Geometry appearance $name \
	       "material {*ambient $RGB *diffuse $RGB}"]
}

proc _geometry(_capture) {name args} {
  global _geometry
  if [catch {_bind(Rest) {{new ""}} {parts= {}} $args _geometry(_capture)} \
	  message] {return -code error $message}
  if [regexp {/} $name] \
      {Error "Object name \"$name\" should not contain \"/\""}
  if [info exists _geometry(B:$name)] {Error "Object \"$name\" already exists"}
  set geom [lindex [_geometry(Get) $name] 0]
  TellGV "(delete $name)"
  if {$new != ""} {set name $new}
  set T [_transform(Get) $name]
  _geometry(Capture) $name $geom $parts
  _geometry(_create) $name "{ : \"G:$name\" }"
  _transform(Set) $T $name
  _frame(Changed)
}

proc _geometry(Capture) {name geom names {T ""}} {
  global _geometry
  if {$T != ""} {_geometry(_transform) $name $T}
  while {[llength $geom] == 1 && $geom != [lindex $geom 0]} \
    {set geom [lindex $geom 0]}
  if {[llength $geom] == 0} {_geometry(_define) $name {}; return}
  if {[lindex $geom 0] == "appearance"} {
    set _geometry(A:$name) [lindex $geom 1]
    set geom [lrange $geom 2 end]
  }
  if {[lindex $geom 0] == "="} {set geom [lrange $geom 1 end]}
  switch -- [lindex $geom 0] {
    LIST {_geometry(CaptureList) $name [lrange $geom 1 end] $names}
    INST {_geometry(CaptureInst) $name [lrange $geom 1 end] $names}
    default {_geometry(_define) $name $geom}
  }
  _geometry(Write) $name
}

proc _geometry(CaptureList) {name geom names} {
  global _matrix _geometry
  set i 0
  set _geometry(B:$name) {}
  foreach part $geom {
    set pname [lindex $names $i]; set pnames {}; incr i
    if {[llength $pname] > 1} {
      set pnames [lrange $pname 1 end]
      set pname  [lindex $pname 0]
    }
    if {$pname == ""} {set pname $i}
    lappend _geometry(B:$name) $pname
    _geometry(Capture) $name/$pname $part $pnames $_matrix(I)
  }
}

proc _geometry(CaptureInst) {name geom names} {
  global _geometry
  set t [lindex $geom 0]; set isINST true
  if {$t == "tlist"} {_geometry(_define) $name " = INST $geom"; return}
  if {$t != "transform"} {Error "Can't capture INST with \"$t\""}
  if {[lindex $geom 2] != "geom" && [llength $geom] > 2} \
      {Error "Expected \"geom\" but found \"[lindex $geom 2]\" in INST"}
  if {[llength $geom] > 4} {Error "Can't understand structure of INST"}
  if [uplevel 2 "info exists isINST"] {
    set pname [lindex $names 0]; set names [lrange $names 1 end]
    if {$pname == ""} {set pname 1}
    set _geometry(B:$name) $pname; _geometry(Write) $name
    set name $name/$pname
  }
  _geometry(_transform) $name [Transpose [lindex $geom 1]]
  _geometry(Capture) $name [lindex $geom 3] $names
}


proc _geometry(_structure) {name} {
  return [_geometry(Structure) [lindex [_geometry(Get) $name] 0]]
}

proc _geometry(Structure) {geom} {
  while {[llength $geom] == 1 && $geom != [lindex $geom 0]} \
    {set geom [lindex $geom 0]}
  if {[llength $geom] == 0} {return {}}
  if {[lindex $geom 0] == "appearance"} {
    set app "appearance "
    set geom [lrange $geom 2 end]
  } else {set app ""}
  if {[lindex $geom 0] == "="} {set geom [lrange $geom 1 end]}
  switch -- [lindex $geom 0] {
    LIST {set list [_geometry(StructureList) [lrange $geom 1 end]]}
    INST {set list [_geometry(StructureInst) [lrange $geom 1 end]]}
    default {set list [lindex $geom 0]}
  }
  return "$app$list"
}

proc _geometry(StructureList) {geom} {
  set list {LIST}
  foreach part $geom {lappend list [_geometry(Structure) $part]}
  return $list
}

proc _geometry(StructureInst) {geom} {
  set list {INST}
  while {[llength $geom] > 0} {
    switch [lindex $geom 0] {
      transform {lappend list "T"}
      tlist {lappend list "Tlist"}
      geom {lappend list [_geometry(Structure) [lindex $geom 1]]}
      default {lappend list "[lindex $geom 0]?"}
    }
    set geom [lrange $geom 2 end]
  }
  return $list
}


proc _geometry(Exists) {name} {
  global _geometry
  return [expr [info exists _geometry(B:$name)] ||\
	       [info exists _geometry(T:$name)]]
}

proc _geometry(Get) {name} {
  GetGV id "(echo (real-id $name)\\n)"; set id [string trim $id]
  if {$id == "nil"} {Error "No such object: \"$name\""}
  AskGV "(write geometry - $id self)(echo \"<< Done >>\\n\")"
  set geom {}
  for {Input line} {$line != "<< Done >>"} {Input line} {lappend geom $line}
  return [join $geom \n]
}


proc _geometry(Write) {name} {
  global _geometry
  if ![info exists _geometry(B:$name)] return
  set list {}
  foreach part $_geometry(B:$name) {
    if {![info exists _geometry(A:$name/$part)] ||
	 [info exists _geometry(B:$name/$part)]} {set app {}} else \
	{set app "appearance {$_geometry(A:$name/$part)} "}
    lappend list \
	"$app= INST transform : \"$name/$part\" geom : \"G:$name/$part\""
  }
  if ![info exists _geometry(A:$name)] {set app {}} else \
      {set app "appearance {$_geometry(A:$name)} "}
  _geometry(_define) $name "$app= LIST $list"
}


##########################################################################
#
#  Dimensions and Transforms
#

proc _driver(GetDimension) {} {
  global _gv 
  GetGV dim "(echo (dimension)\\n)"
  set dim [expr $dim]; set _gv(dim) $dim
  if {$dim == 0} {set dim 3}
  return $dim
}

proc _driver(SetDimension) {d} {
  global _gv
  set _gv(dim) $d
  if {$d == 0} {set d 3; TellGV "(dimension 0)"} \
      else {TellGV "(dimension $d)(ND-axes [_gv(Camera)] cluster1 0 1 2)"}
  return $d
}

proc _driver(GetTransform) {object} {
  global _gv _matrix _geometry
  if [info exists _geometry(T:$object)] {return $_geometry(T:$object)}
  if {$_gv(dim) == 0} {
    set parent "world"
    if {$object == $parent || $object == "g0"} {set parent ""}
    set xform "write transform - $object $parent"
  } else {
    set xform "echo (ND-xform $object)\\n"
  }
  AskGV "(if (real-id $object) ($xform) (echo \"\n$_matrix(I)\n\n\n\"))"
  for {set i 0} {$i < $_matrix(dim)+4} {incr i} {
    Input line
    regsub -all { +} [string trim $line] { } line
    if {$i > 0 && $i < $_matrix(dim)+2} {lappend M $line}
  }
  return [Transpose [join $M \n]]
}

proc _driver(SetTransform) {object M} {
  global _gv _matrix _geometry
  if [info exists _geometry(T:$object)] {
    _geometry(_transform) $object $M
  } else {
    set M [Transpose $M]
    if {$_gv(dim) == 0} {
      TellGV "(xform-set $object $M)"
    } else {
      TellGV "(ND-xform $object $_matrix(d+1) $_matrix(d+1) $M)"
    }
  }
}
