Require quote.tcl

set _gv(frame) ""
set _gv(camera) "Camera"
set _gv(ignoreModules) {.*FrontStage {.*StageDoor geomview}}
set _gv(dim)   0
set _gv(path) ""

proc _driver(HandleError) {} {_command(TellGV) "(redraw [_gv(Camera)])"}
proc _driver(Paused) {state} {if {$state} _gv(Redraw) else _gv(Freeze)}
proc _driver(Pause)  {frames} {UpdateGV}
proc _driver(Fade)   {frames} {UpdateGV}

proc _gv(Begin) {movie} {
  global _options _gv
  _gv(SetPath)
  _matrix(Begin)
  _geometry(Begin) $movie
  if {$_options(killModules)} _gv(KillModules)
  if {$_options(resetGV)}     _gv(Reset)
  _gv(Freeze)
}

proc _gv(End) {} {_gv(Redraw)}

proc _gv(Redraw) {} {SyncGV "(redraw [_gv(Camera)])"}
proc _gv(Freeze) {} {TellGV "(freeze [_gv(Camera)])"}


proc _gv(SetPath) {} {
  global _gv _file
  if {$_gv(path) == ""} {
    GetGV line "(echo (load-path)\\n)"
    set line [string trim $line]
    set _gv(path) [string range $line 1 [expr [string length $line] - 2]]
  }
  if {![info exists _file(pwd)] || $_file(pwd) == ""} return
  foreach dir $_gv(path) {if {$dir == $_file(pwd)} return}
  TellGV "(set-load-path ($_gv(path) $_file(pwd)))"
}


proc _gv(Reset) {} {
  TellGV "(delete allgeoms)(new-reset)(bbox-draw world no)"
  TellGV "(camera-reset [_gv(Camera)])(normalization world none)"
  _frame(Changed)
}

proc _gv(KillModules) {} {
  global _gv _action
  if {$_action(driver)} {
    GetGV mods "(echo (all emodule running)\\n)"
    set mods [string trim $mods]
    set mods [string range $mods 1 [expr [string length $mods] - 2]]
    foreach module $mods {
      set kill true
      foreach name $_gv(ignoreModules) {
	if [regexp "^\\\[\[0-9\]+\\\]$name\$" $module] {set kill false; break}
      }
      if {$kill} {_command(TellGV) "(emodule-start \"[_Quote $module]\")"}
    }
    SyncGV
  }
}

proc _gv(Camera) {{name ""}} {
  global _gv
  if {$name ==""} {set name $_gv(camera)}
  return $name
}

proc ResetGV {} {_gv(Reset)}

proc ResetCamera {{camera ""}} {
  set camera [_gv(Camera) $camera]
  SyncGV "(new-center $camera)(new-center world)(camera-reset $camera)"
}

proc Camera {name} {
  global _gv
  _gv(Redraw)
  set _gv(camera) $name
  _gv(Freeze)
  _frame(Changed)
}

proc Projection {type {camera ""}} {
  set camera [_gv(Camera) $camera]
  switch $type {
    Orthographic {SyncGV "(merge camera $camera {perspective 0})"}
    Perspective  {SyncGV "(merge camera $camera {perspective 1})"}
    default {return -code error "Unknown projection type: $type"}
  }
  _frame(Changed)
}

proc Appearance {object appearance} {
  foreach obj $object {SyncGV "(merge-ap \"[_Quote $obj]\" {$appearance})"}
  _frame(Changed)
}

proc Color {object RGB} {
  uplevel [list "Appearance" $object "material {*ambient $RGB *diffuse $RGB}"]
}

proc Background {RGB {camera ""}} {
  SyncGV "(backcolor [_gv(Camera) $camera] $RGB)"
  _frame(Changed)
}

proc UpdateGV {{camera ""}} {
  set camera [_gv(Camera) $camera]
  SyncGV "(redraw $camera)(freeze $camera)"
}

proc Send {process message} {
  global _action
  if $_action(driver) {send $process $message}
}

proc Load {object args} {
  foreach name [concat [list $object] $args] \
      {TellGV "(load \"[_Quote $name]\")"}
  _command(SyncGV)
  _frame(Changed)
}

proc Delete {object args} {
  foreach name [concat [list $object] $args] \
      {TellGV "(delete \"[_Quote $name]\")"}
  _command(SyncGV)
  _frame(Changed)
}



proc VideoSize {} {
  global _image
  eval WindowSize [split $_image(.video.size) x]
}
proc MpegSize {} {
  global _image
  eval WindowSize [split $_image(.mpeg.size) x]
}

proc WindowSize {w h {x ""} {y ""}} {
  _driver(SizeWindow) $w $h $x $y
  _frame(Changed)
}

proc _driver(Sleep) {seconds {force 0}} {
  global _options
  if {$force} {_gv(Redraw); SyncGV "(sleep-for $seconds)"; _gv(Freeze)} \
      elseif {$_options(framePauses)} {SyncGV "(sleep-for $seconds)"} \
      else {SyncGV}
}

proc _driver(BeginSnapshot) {{frame 0}} {
  global _action _image
  if {$frame && $_image(shader) == "rib"} {uplevel {set type "rib"}}
}
