Require input.tcl
Require quote.tcl

set _action(driver) 1


proc TellGV {args} {eval _command(TellGV) $args}
proc AskGV {args} {eval _command(AskGV) $args}
proc GetGV {var args} {upvar $var v; eval _command(AskGV) $args; Input v}

proc SyncGV {args} {
  if {$args != ""} {eval TellGV $args}
  _command(SyncGV)
}

proc _command(TellGV) {args} {
  global _command
  set line [join $args \n]
  if {$_command(module) == ""} {
    puts "Tell [expr [string length $line] + 1]"
    puts $line
    puts {}
  } else {
    puts $line
  }
  flush stdout
}

proc _command(AskGV) {args} {
  global _command
  if {$_command(module) == ""} {
    set line [join $args \n]
    puts "Ask [string length $line]"
    puts $line
  } else {
    puts "(progn\n[join $args \n]\n)"
  }
  flush stdout
}

proc _command(SyncGV) {} {
  global _action
  if $_action(driver) {_command(AskGV) "(echo Sync\\n)"; Input sync}
}

proc _driver(Print) {lines} {
  global _command
  puts -nonewline "(emodule-transmit \"$_command(hub)\" \""
  foreach line $lines {puts [_Quote $line]}
  puts "\")"
}

proc _driver(Kill) {module} {
  set module [_Quote $module]
  puts "(if (emodule-isrunning \"$module\") (emodule-start \"$module\"))"
  flush stdout
}
