Require send.tcl

proc Send {proc script} {_status(Check); send $proc $script}

proc FrontStage {action args} {
  global _action

  if {$_action(driver)} {
    switch $action {

      Start {
	SyncGV "(if (emodule-isrunning FrontStage) () \
                    (progn (emodule-start FrontStage) (sleep-for 3)))"
      }
      
      Stop {
	SyncGV "(emodule-start [1]FrontStage)(sleep-for 1)
                (emodule-start [1]FrontStage)"
      }

      Update {
	if [catch {Send FrontStage "Update"} message] {
	  global errorCode errorInfo
	  set maxtries 15
	  for {set i 0} {$i < $maxtries} {incr i} \
	      {if ![catch {Send FrontStage {}}] return}
	  return -code error -errorinfo $errorInfo \
	      -errorcode $errorCode $message
	}
      }

      Set {Send FrontStage [concat Set $args]}
      Tell {Send FrontStage $args}
      Sync {Send FrontStage "SyncGV"}

      default {Error "Undefined FrontStage action: $action"}

    }
  }
}