Require gv-snapshot.tcl
Require gv-window.tcl
Require commands.tcl


###################################################################
#
#  Image commands
#


proc _driver(BeginSnapshot) {} {
  global _image _driver shader
  switch $shader {
    Software  {set _image(shader) "ppm"}
    MESA      {set _image(shader) "ppmmesa"}
    Hardware  {set _image(shader) "ppmscreen"}
    Renderman {set _image(shader) "rib"}
  }
  upvar w w; upvar h h
  _driver(SizeWindow) $w $h
}

proc _driver(EndSnapshot) {} {
  global _image shader
  upvar w w; upvar h h
  _gv(SizeWindow) $w $h
  switch $shader {
    Renderman {
      _message(Set) "Rendering RIB file"
      set name [uplevel set name]
      if ![regexp {.rib$} $name] {set name $name.rib}
      eval exec [_cmd(RIB) $name]
      exec /bin/rm -f $name
      set _image(tmpfile) [file rootname $name].tiff
    }
  }
  set _image(shader) "ppm"
}


###################################################################
#
#  Communications with Geomview
#

proc TellGV {args} {eval _command(TellGV) $args}
proc AskGV {args} {eval _command(AskGV) $args}
proc GetGV {var args} {upvar $var v; eval _command(AskGV) $args; Input v}
proc SyncGV {args} {if {$args != ""} {eval TellGV $args}; _command(SyncGV)}

proc _command(TellGV) {args} {puts [join $args \n]; flush stdout}
proc _command(AskGV)  {args} {puts "(progn\n[join $args \n]\n)"; flush stdout}
proc _command(SyncGV) {} {_command(AskGV) "(echo Sync\\n)"; Input sync}

proc Input {var} {upvar $var v; gets stdin v}

proc _gv(Redraw) {} {SyncGV "(redraw [_gv(Camera)])"}
proc _gv(Freeze) {} {}
proc _gv(Camera) {} {global _gv; return $_gv(camera)}


###################################################################
#
#  Add window widgets
#


_label(Entry) .frame camera "Camera:" _gv(camera)
pack .frame.camera(frame) -before .frame.bbox
pack .frame.camera -expand true -fill x

_label(Menu) .frame.frame \
  shader " Shader: " shader {Software Hardware Renderman} Software 10
.frame.frame.shader.menu entryconfig "Hardware"  -state disabled
.frame.frame.shader.menu entryconfig "Renderman" -state disabled
catch {
  if {[string index [exec which [_cmd(RIB) {}]] 0] == "/"} \
    {.frame.frame.shader.menu entryconfig "Renderman" -state normal}
}

_ctrlK(Bind) .frame.camera


_gv(Version)
GetGV _gv(sgi) {(echo (sgi)\n)}
set _gv(sgi) [expr {!($_gv(sgi) == "nil ")}]

if ![_gv(EarlierV) 1.6] {
  if {$_gv(sgi) || $_gv(mesa)} \
    {.frame.frame.shader.menu entryconfigure "Hardware" -state normal}
  if {$_gv(mesa)} {
    set _menu(position) [.frame.frame.shader.menu index "Renderman"]
    _menu(Menu) .frame.frame shader.menu {{Action MESA {set shader MESA}}}
  }
}

.frame.camera selection range 0 end
.frame.camera icursor end
focus .frame.camera






