Require gv-snapshot.tcl
Require gv-window.tcl

###################################################################
#
#  Resize Window

proc _driver(Resize) {} {
}


###################################################################
#
#  Communications with Geomview
#

proc TellGV {args} {eval _command(TellGV) $args}
proc AskGV {args} {eval _command(AskGV) $args}
proc GetGV {var args} {upvar $var v; eval _command(AskGV) $args; Input v}
proc SyncGV {args} {if {$args != ""} {eval TellGV $args}; _command(SyncGV)}

proc _command(TellGV) {args} {foreach line $args {puts $line}; flush stdout}
proc _command(AskGV) {args} {puts "(progn $args)"; flush stdout}
proc _command(SyncGV) {} {_command(AskGV) "(echo Sync\\n)"; Input sync}

proc Input {var} {upvar $var v; gets stdin v}


###################################################################
#
#  Add window widgets
#


_label(Entry) .frame camera "Camera:" _gv(camera)
_button(Button) .frame top Action resize "_Resize Window..." _driver(Resize)
pack .frame.camera(frame) .frame.resize -before .frame.box
pack .frame.camera -expand true -fill x

_label(Menu) .frame.frame \
  shader " Shader: " shader {Software RIB} Software 10

_ctrlK(Bind) .frame.camera


_gv(Version)
GetGV _gv(sgi) {(echo (sgi)\n)}
set _gv(sgi) [expr {!($_gv(sgi) == "nil ")}]

if ![_gv(EarlierV) 1.6] {
  set _menu(position) [.frame.frame.shader.menu index "RIB"]
  _menu(Menu) .mbar image.menu {
    {Menu S_hader shader 
      {{Radio "_Software" _image(shader) ppm _gv(NewShader) checked}}
    }
  }
  if {$_gv(sgi) || $_gv(mesa)} {
    _menu(Menu) .mbar.image.menu shader \
      {{Radio "_Hardware" _image(shader) ppmscreen _gv(NewShader)}}
  }
  if {$_gv(mesa)} {
    _menu(Menu) .mbar.image.menu shader \
      {{Radio "_MESA" _image(shader) ppmmesa _gv(NewShader)}}
  }
}

.frame.camera selection range 0 end
.frame.camera icursor end
focus .frame.camera

