Require gv-IO.tcl
Require gv-snapshot.tcl
Require gv-window.tcl

set _driver(version) 1.0

#
#  Minimum version whose data can be read
#
set _driver(majorV) 0
set _driver(minorV) 0


###########################################################################
#
#  Driver version compatibility
#

proc _driver(FileV) {version} {
  global _driver
  set v [split $version .]
  set M [lindex $v 0]; set m [lindex $v 1]
  if {$M < $_driver(majorV) || \
      ($M == $_driver(majorV) && $m < $_driver(minorV))} \
    {Error "Driver version mismatch:  $M.$m is too old to read!"}
}

proc _driver(EarlierV) {V} {
  global _file
  set vv [split $V .]
  set vf [split $_file(dversion) .]
  set Mv [lindex $vv 0]; set mv [lindex $vv 1]
  set Mf [lindex $vf 0]; set mf [lindex $vf 1]
  return [expr $Mf < $Mv || ($Mf == $Mv && $mf < $mv)]
}

lappend _pack(Array:_options) killModules resetGV
lappend _image(.pack) shader

proc _driver(vCheck) {type list} {
  switch $type {
    Image2.4 {
      #
      #  Fix up things for pre-version 2.5
      #  should have used _driver(EarlierV) if it had existed then
      #
      if [_file(EarlierV) 2.2] {set list [linsert $list 6 ppm]}
      if [_file(EarlierV) 2.4] {set list [linsert $list 4 90]}
      if {[lindex $list 7] == "0"} {set list [lreplace $list 7 7 ppm]}
      if {[lindex $list 7] == "1"} {set list [lreplace $list 7 7 ppmscreen]}
    }
  }
  return $list
}


###########################################################################
#
#  Add GV-specific menus and buttons
#

.mbar.options.menu.stop insert 1 radio -label "Every Sequence" \
  -underline 6 -value sequence -variable _options(stopAt)
.mbar.options.menu.stop entryconfigure 2 -underline 7

_menu(Bar) . mbar {
  _Options options {
     Line
    {Check "_Reset Geomview" _options(resetGV) {} checked}
    {Check "_Kill Modules"   _options(killModules)}
    {Check "Frame _Pauses"   _options(framePauses)} 
  }
  _Tools tools {
    {Action _CenterStage     _tool(CenterStage)}
     Line
    {Action "Run _GCL..."    _tool(RunGCL)}
  }
}

_menu(Menu) .mbar.image.menu type {
  Line
  {Radio _RIB  _image(type) rib}
}

proc _tool(CenterStage) {} {StageDoor "Start CenterStage"}
lappend _pack(vars) _options(resetGV) _options(killModules)


set _menu(position) [.mbar.action.menu index "Make MPEG"]
_menu(Menu) .mbar action.menu {
  {Check "Save _GCL"     _action(gcl)}
  {Check "Render _RIB"   _action(rib)}
}
lappend _movie(reset.actions) gcl rib


###########################################################################
#
#  Image files
#

proc _driver(EndSnapshot) {} {
  global _image
  if {$_image(shader) == "rib"} {
    wm title . "Rendering RIB file"; update idletasks
    set name [uplevel set name]
    if ![regexp {.rib$} $name] {set name $name.rib}
    eval exec [_cmd(RIB) $name]
    exec /bin/rm -f $name
    set _image(tmpfile) [file rootname $name].tiff
  }
}


###########################################################################
#
#  Execution Actions and Filenames
#

proc _driver(GetActions) {} {
  global _movie _action
  set _action(preview) [expr $_action(preview) && !$_action(gcl) && \
			    !$_action(rib)]
  set _action(driver)  [expr $_action(driver) || $_action(gcl) ]
}

proc _driver(GetFilenames) {} {
  global _file _movie
  set _file(gcl)    "$_file(base).gcl"
  set _file(render) "$_file(base).render"
}

proc _driver(CheckFiles) {} {
  global _file _action
  if [_execute(Confirm) $_action(gcl) $_file(gcl)] {return -code return 1}
}

proc _driver(TemporaryFileNames) {} {global _file; return $_file(render)}
proc _driver(OutputFileNames)  {} {global _file; return $_file(gcl)}


###########################################################################
#
#  Add to Shader menus
#

proc _gv(Redraw) {} {}
proc _gv(Freeze) {} {}
_gv(Version)
_image(GetSize)

GetGV _gv(sgi) {(echo (sgi)\n)}
set _gv(sgi) [expr {!($_gv(sgi) == "nil ")}]

set _menu(position) [.mbar.image.menu index "Colors"]
_menu(Menu) .mbar image.menu {
  {Menu 
    S_hader shader {
      {Radio "_Software"  _image(shader) ppm _gv(NewShader) checked}
      {Radio "_Hardware"  _image(shader) ppmscreen _gv(NewShader)}
      {Radio "_Renderman" _image(shader) rib _gv(NewShader)}
    }
  }
}
.mbar.image.menu.shader entryconfig "Hardware"  -state disabled
.mbar.image.menu.shader entryconfig "Renderman" -state disabled
.mbar.action.menu entryconfig "Render RIB" -state disabled
catch {
  if {[string index [exec which [_cmd(RIB) {}]] 0] == "/"} {
    .mbar.image.menu.shader entryconfig "Renderman" -state normal
    .mbar.action.menu entryconfig "Render RIB" -state normal
  }
}

if ![_gv(EarlierV) 1.6] {
  if {$_gv(sgi) || $_gv(mesa)} \
    {.mbar.image.menu.shader entryconfig "Hardware" -state normal}
  if {$_gv(mesa)} {
    set _menu(position) [.mbar.image.menu.shader index "Renderman"]
    _menu(Menu) .mbar.image.menu shader \
      {{Radio "_MESA" _image(shader) ppmmesa _gv(NewShader)}}
  }
}
