Require quote.tcl

set _IO(self) ""

proc _driver(Print) {name args} {
  global _IO
  set pipe $_IO($name.file)
  set module [_Quote $_IO($name.module)]
  puts -nonewline $pipe "(emodule-transmit \"$module\" \""
  foreach line $args {puts $pipe [_Quote $line]}
  puts $pipe "\")"
  flush $pipe
}

proc _driver(Tell) {name line} {
  puts -nonewline stdout $line
  flush stdout
}

proc _driver(Ask) {name tag line} {
  puts "(progn"
  puts "  (echo \"Route $name {[_QuoteBraces $tag]}\\n\")"
  puts    $line
  puts "  (echo \"$tag\\n\")"
  puts ")"
  flush stdout
}

proc _driver(Kill) {proc} {
  set proc [_Quote $proc]
  puts "(emodule-start \"$proc\")"
  puts "(sleep-for 1)(emodule-start \"$proc\")";    # for bug in geomview
  flush stdout
}


proc _IO(FindSelf) {module} {
  puts "(progn
          (echo \"FindSelf {[_QuoteBraces [_Quote $module]]}\\n\")
          (echo (all emodule running))(echo \\n)
        )"
  flush stdout
}

proc _IO(_FindSelf) {name pattern} {
  set pid [pid]
  gets stdin list
  set list [lsort [string range $list 1 [expr [string length $list] - 2]]]
  puts "(progn"
  foreach module $list {
    if {[regexp "^\\\[\[0-9\]+\\\]$pattern$" $module]} {
      set module [_Quote $module]
      puts "(emodule-transmit \"$module\"
                 \"FindPID $pid {[_QuoteBraces $module]}\\n\")"
    }
  }
  puts ")"
  flush stdout
}

proc _IO(_FindPID) {name pid module} {
  global _IO
  if {$_IO(self) == "" && [pid] == $pid} {set _IO(self) $module}
}


proc _IO(Module) {proc start module} {
  global _IO _require
  set module [_Quote $module]
  if {$start == "start"} {set command $module} \
      else {set command "$module $_require(driver)"}
  puts "(progn
          (echo \"Module $proc {[_QuoteBraces $module]}\\n\")
          (echo (all emodule running))(echo \\n)
          (emodule-$start \"$command\")
          (echo (all emodule running))(echo \\n)
        )"
  flush stdout
  return stdout
}

proc _IO(_Module) {name proc module} {
  global _IO
  gets stdin list1
  gets stdin list2
  set list1 [lsort [string range $list1 1 [expr [string length $list1] - 2]]]
  set list2 [lsort [string range $list2 1 [expr [string length $list2] - 2]]]
  set i 0
  foreach emodule $list2 {
    if {$emodule != [lindex $list1 $i]} {set module $emodule; break}
    incr i
  }
  set _IO($proc.file) stdout
  set _IO($proc.module) $module
  if {$_IO(self) != ""} {
    set command "set _command(hub) {$_IO(self)}"
    _IO(Print) $proc "<< Command: {} {} [string length $command] >>" $command
  }
}


proc _CenterStage(Start) {} {
  global _IO
  puts "(progn (if (emodule-isrunning CenterStage)
                  (progn 
                    (echo \"Register CenterStage CenterStage\n\")
                    (echo \"CenterStageRunning\n\")
                  )"
  _IO(Module) CenterStage start CenterStage
  puts "  ))"
  flush stdout
  set after [after 60000 {set _IO(CenterStage.module) {CenterStage}}]
  tkwait variable _IO(CenterStage.module)
  catch {after cancel $after}
  return stdout
}

proc _IO(_CenterStageRunning) {name} {
  global _IO
  if {$_IO(self) != ""} {
    set command "set _command(hub) {$_IO(self)}"
    _IO(Print) CenterStage \
	"<< Command: {} {} [string length $command] >>" $command
  }
  _IO(_Register) stdin CenterStage CenterStage
}

_IO(FindSelf) "StageDoor"
