Require status.tcl
Require math.tcl

Require gv-IO.tcl
Require gv-snapshot.tcl
Require gv-window.tcl
Require gv-commands.tcl
Require gv-script.tcl
Require gv-geometry.tcl
Require gv-CenterStage.tcl
Require gv-FrontStage.tcl


###########################################################################
#
#  Geomview communication
#

proc TellGV {args} {
  global _action _gcl
  _status(Check)
  if {$_action(gcl)} {puts $_gcl(file) [join $args \n]}
  if {$_action(driver)} {eval _command(TellGV) $args}
}
proc SyncGV {args} {if {$args != ""} {eval TellGV $args}; _command(SyncGV)}


###########################################################################
#
#  Execution initialization commands
#

proc _driver(Begin) {movie} {
  global _action _gv env
  if {$_action(driver) && ![info exists env(GEOMROOT)]} {
    ErrorMessage \
	[concat \
	     "This program is a Geomview external Module." \
	     "To use it, start Geomview and select the" \
	     "StageManager external module." ]
  }
  _gv(Version)
  _render(Begin)
  _gcl(Begin)
  _gv(Begin) $movie
}

proc _driver(End) {movie} {
  global _action
  _gv(End)
  _render(End)
  _gcl(End)
}


proc _driver(BeginReceive) {} {
  global _scene _scenes
  _driver(InitArray) _action {
     animGIF frames gcl mpeg rib video {driver 1} {preview 1} {snapshot 1}
  } 0
  _driver(InitArray) _file {animGIF base frameroot gcl
    imageroot mpeg param pwd render root video} "."
  _driver(InitArray) _options {framePauses killModules resetGV {stopAt end}} 0
  _driver(InitArray) _frame {resolution speed pause} 1
  _driver(InitArray) _image {{quality 90} {type gif} {size wh} {W 288}
    {wh 288x288} {w 288} {H 288} {h 288} {colors 255} {shader ppm}}
  catch {unset _scenes}
  set _scene(list) {}
  set _scene(all) 1
}

proc _driver(InitArray) {name list {default ""}} {
  upvar \#0 $name A
  foreach id [concat [array names A] $list] {
    if {[string index $id 0] != "."} {
      if {[llength $id] == 1} {set value $default} \
        else {set value [lindex $id 1]; set id [lindex $id 0]}
      set A($id) $value
    }
  }
}

proc _driver(EndReceive) {} {_gv(Redraw)}


###########################################################################
#
#  Image control
#

proc _driver(BeginSnapshot) {{frame 0}} {
  global _action _image
  if {$frame} {
    if {$_image(shader) == "rib"} {uplevel {set type "rib"}}
  } else {
    if {$_action(snapshots)} {
      uplevel {
        if {$w != $_image(w) || $h != $_image(h) && $_image(shader) != "ppm"} \
                  {_driver(SizeWindow) $w $h}
      }
      _gv(Redraw)
    }
  }
}

proc _driver(EndSnapshot) {{frame 0}} {
  global _action
  if {!$frame && $_action(snapshots)} {
    uplevel {
      if {$w != $_image(w) || $h != $_image(h) && $_image(shader) != "ppm"} \
                {_driver(SizeWindow) $_image(w) $_image(h)}
    }
    _gv(Freeze)
  }
}


###########################################################################
#
#  Renderman output
#

proc _render(Begin) {} {
  global _action _render _file _image
  if {$_action(frames) && $_image(type) == "rib"} \
      {_gv(SizeWindow) $_image(W) $_image(H)}
  if {$_action(rib)} {
    set _render(file) [open $_file(render) w]
    _render(Header)
  }
}

proc _render(End) {} {
  global _render _action _image
  if {$_action(frames) && $_image(type) == "rib"} \
      {_gv(SizeWindow) $_image(w) $_image(h)}
  if {$_action(rib)} {
    _render(Footer)
    close $_render(file)
    _render(Render)
  }
}

proc _render(Frame) {name} {
  global _render _action _gv
  if {$_action(rib)} {
    if {!($_action(frames) || $_action(mpeg) || $_action(video))} \
	{_status(Message) " $name"}
    puts $_render(file)  "Render \"$name\""
  }
}

proc _driver(BeginFrame) {name} {_gv(Redraw); _render(Frame) $name}
proc _driver(EndFrame) {name} {_gv(Freeze)}


proc _render(Header) {} {
  global _render _image _movie
  set colors $_image(colors); set type $_image(type)
  if {$colors == "Millions"} {set colors ""}
  if {$type == "rib"} {set type "tiff"}
  set render [_cmd(RIB) {$1.rib}]
  set convert \
    [_cmd(Convert) {$1.tiff} {$1} $type $_image(w) $_image(h) $colors]

  puts $_render(file) "\#! /bin/sh -e\n\#\n\#\n"
  puts $_render(file) "\#  script to render RIB files for $_movie(name)"
  puts $_render(file) "\#\n\#\n"
  puts $_render(file) "Render() {"
  puts $_render(file) " echo \" \$1\""
  puts $_render(file) " if \[ ! -f \$1 \]; then"
  puts $_render(file) "  $render"
  puts $_render(file) "  $convert"
  puts $_render(file) "  /bin/rm -f \$1.tiff"
  puts $_render(file) " fi"
  puts $_render(file) "}"
  puts $_render(file) ""
}
proc _render(Footer) {} {}

proc _render(Render) {} {
  global _render _file
  _status(Message) "\n================================"
  _status(Message) "================================\n"
  _status(Message) "Rendering RIB files"
  exec /bin/chmod +x $_file(render)
  set render [open "| $_file(render)" r]
  while {! [eof $render]} {gets $render line; _status(Message) $line}
  close $render
  _status(Message) "================================"
  _status(Message) "Rendering complete\n"
}


##########################################################################
#
#  GCL output
#

proc _gcl(Begin) {} {
  global _action _gcl _file
  if {$_action(gcl)} {set _gcl(file) [open $_file(gcl) w]}
}

proc _gcl(End) {} {
  global _gcl _action
  if {$_action(gcl)} {close $_gcl(file)}
}
