//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.parameter;

import java.util.Vector;
import java.util.Hashtable;

public class ParameterTestApplication extends ParameterApplication {
    public static void main( String[ ] args ) {
        ParameterTestApplication application = new ParameterTestApplication( );

        application.init( args );
        application.start( );
    }

    private void start( ) {
        parameter.setStub( new ParameterExpandStub( parameter.getStub( ), parameter ));

        try {
            String    target    = parameter.getString   ( ""         ,               null );
            String[ ] array     = parameter.getArray    ( "array"    , ( String[ ] ) null );
            Vector    vector    = parameter.getVector   ( "vector"   , ( Vector    ) null );
            Hashtable hashtable = parameter.getHashtable( "hashtable", ( Hashtable ) null );

            if( target    != null ) System.out.println( "target   : " + target    );
            if( array     != null ) System.out.println( "array    : " + arrayToString( array ));
            if( vector    != null ) System.out.println( "vector   : " + vector    );
            if( hashtable != null ) System.out.println( "hashtable: " + hashtable );
        } catch( Exception e ) {
            e.printStackTrace( );
        }
    }

    private String arrayToString( Object[ ] array ) {
        StringBuffer buffer = new StringBuffer( );

        buffer.append( '[' );
        for( int i = 0; i < array.length; ) {
            buffer.append( array[ i ] );

            ++ i;
            if( i < array.length )
                buffer.append( ", " );
        }
        buffer.append( ']' );

        return buffer.toString( );
    }
}
