//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.parameter;

import java.io.File;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Hashtable;

public class ParameterApplication implements ParameterStub {
    protected ParameterProcessor    parameter;
    private Hashtable                       values = new Hashtable( );
    private String                          name;

    public void init( String[ ] arguments ) {
        for( int index = 0; index < arguments.length; ++ index )
            if( arguments[ index ].charAt( 0 ) == '-' ) {
                if( index + 1 < arguments.length ) {
                    String key = arguments[ index ].substring( 1 ).toLowerCase( );
                    String element = arguments[ index + 1 ];
                    values.put( key, element );
                    ++ index;
                }
            } else
                values.put( "", arguments[ index ] );
        
        URL base;

        try {
            base = new URL( "file:" + new File( "" ).getAbsolutePath( ));
        } catch( MalformedURLException e ) {
            base = null;
        }

        parameter = new ParameterProcessor( this, base );
    }

    public String getParameter( String parameterName ) {
        return ( String ) values.get( parameterName.toLowerCase( ));
    }
}
